<?php
// Script temporal para restaurar la base de datos SICA
require_once 'config/db.php';

echo "=== RESTAURANDO BASE DE DATOS SICA ===\n\n";

try {
    // Primero eliminar y recrear la base de datos
    echo "1. Eliminando base de datos anterior (si existe)...\n";
    $pdo->exec("DROP DATABASE IF EXISTS sica2025");
    echo "   ✓ Base de datos eliminada\n\n";

    echo "2. Creando nueva base de datos...\n";
    $pdo->exec("CREATE DATABASE sica2025 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "   ✓ Base de datos creada\n\n";

    echo "3. Seleccionando base de datos...\n";
    $pdo->exec("USE sica2025");
    echo "   ✓ Base de datos seleccionada\n\n";

    // Leer el script SQL de restauración
    $sql_restauracion = file_get_contents('database/sica_completo_restauracion.sql');
    echo "4. ✓ Script de restauración leído\n";

    // Leer el script de datos básicos
    $sql_datos = file_get_contents('database/datos_basicos_completos.sql');
    echo "5. ✓ Script de datos básicos leído\n\n";

    // Unir ambos scripts
    $sql_completo = $sql_restauracion . "\n\n" . $sql_datos;

    // Dividir en consultas individuales (mejor regex)
    $queries = preg_split('/;[\r\n]+/', $sql_completo);

    echo "6. Ejecutando consultas SQL...\n";
    $ejecutadas = 0;
    $errores = 0;

    foreach ($queries as $query) {
        $query = trim($query);
        if (empty($query)) {
            continue;
        }

        // Saltar comentarios y líneas SELECT de verificación
        if (preg_match('/^(--|\/\*|\*\/|SELECT\s.*FROM)/', $query)) {
            continue;
        }

        try {
            $pdo->exec($query);
            $ejecutadas++;
            if ($ejecutadas % 50 == 0) {
                echo "   Procesando... ($ejecutadas consultas)\r";
            }
        } catch (PDOException $e) {
            $errores++;
            $query_preview = substr($query, 0, 60);
            echo "   ⚠ Error: $query_preview...\n";
        }
    }

    echo "\n   ✓ Consultas ejecutadas: $ejecutadas\n";

    echo "\n=== RESUMEN ===\n";
    echo "Consultas ejecutadas: $ejecutadas\n";
    echo "Errores: $errores\n";

    // Verificar datos insertados
    echo "\n=== VERIFICACIÓN ===\n";
    $tablas = [
        'anios_lectivos',
        'niveles',
        'turnos',
        'grados',
        'secciones',
        'horarios',
        'estados_asistencia',
        'tipos_incidencia',
        'areas_academicas',
        'calendario',
        'configuracion',
        'usuarios',
        'estudiantes',
        'docentes',
        'auxiliares',
        'apoderados'
    ];

    foreach ($tablas as $tabla) {
        try {
            $stmt = $pdo->query("SELECT COUNT(*) FROM $tabla");
            $count = $stmt->fetchColumn();
            echo sprintf("✓ %-25s: %d registros\n", $tabla, $count);
        } catch (Exception $e) {
            echo sprintf("✗ %-25s: Error\n", $tabla);
        }
    }

    echo "\n=== BASE DE DATOS RESTAURADA EXITOSAMENTE ===\n";

} catch (Exception $e) {
    echo "\n✗ Error fatal: " . $e->getMessage() . "\n";
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
}
