# Módulo de Reportes - Reporte Individual de Asistencia

**SICA - Sistema Integrado de Convivencia y Asistencia**

Fecha de creación: 2025-01-04
Estado: ✅ COMPLETADO Y FUNCIONAL

---

## 📋 Descripción General

El **Reporte Individual de Asistencia** es una herramienta integral para el análisis detallado del comportamiento de asistencia de cada estudiante. Proporciona estadísticas completas, alertas automáticas y recomendaciones de acción para mejorar la retención estudiantil.

---

## 🎯 Características Principales

### 1. **Información Completa del Estudiante**
- Datos personales: DNI, nombres completos, género
- Información académica: Nivel, Grado, Sección, Turno
- Año lectivo actual
- Círculo de progreso visual del porcentaje de asistencia

### 2. **Estadísticas Detalladas**
- **Total de días registrados** en el periodo
- **Asistencias**: Conteo y porcentaje
- **Tardanzas**: Conteo total y minutos acumulados
- **Faltas Justificadas**: Conteo
- **Faltas Injustificadas**: Conteo y porcentaje
- **Promedio de minutos de tardanza** por llegada tarde

### 3. **Sistema de Alertas Inteligente**

El sistema detecta automáticamente 5 tipos de alertas:

#### **🔴 ALERTA CRÍTICA: Riesgo de Perder Año**
- **Condición:** ≥30% de faltas injustificadas
- **Mensaje:** "El estudiante tiene X% de faltas injustificadas. Supera el límite del 30%."
- **Acción recomendada:** Intervención inmediata requerida. Contactar a apoderado y tutoría.
- **Color:** Rojo (#dc3545)

#### **🟠 ALERTA ALTA: Exceso de Faltas Injustificadas**
- **Condición:** ≥20% de faltas injustificadas
- **Mensaje:** "El estudiante tiene X% de faltas injustificadas. Se acerca al límite del 30%."
- **Acción recomendada:** Monitorear estrechamente. Considerar llamada a apoderado.
- **Color:** Naranja (#fd7e14)

#### **🟠 ALERTA ALTA: Baja Asistencia General**
- **Condición:** <70% de asistencia general
- **Mensaje:** "El estudiante solo asiste el X% de los días."
- **Acción recomendada:** Investigar causas. Revisar si necesita apoyo adicional.
- **Color:** Naranja (#fd7e14)

#### **🟡 ALERTA MEDIA: Exceso de Tardanzas**
- **Condición:** ≥10 tardanzas en el periodo
- **Mensaje:** "El estudiante tiene X tardanzas en el periodo."
- **Acción recomendada:** Considerar cambio de turno o revisar rutinas matutinas.
- **Color:** Amarillo (#ffc107)

#### **🟡 ALERTA MEDIA: Tardanzas Frecuentes**
- **Condición:** ≥5 tardanzas en el periodo
- **Mensaje:** "El estudiante tiene X tardanzas en el periodo."
- **Acción recomendada:** Monitorear. Conversar con estudiante sobre punctualidad.
- **Color:** Azul (#17a2b8)

#### **🟠 ALERTA ALTA: Faltas Consecutivas**
- **Condición:** 3 o más faltas consecutivas
- **Mensaje:** "El estudiante tiene X faltas consecutivas."
- **Acción recomendada:** Contactar inmediatamente a la familia para verificar situación.
- **Color:** Naranja (#fd7e14)

#### **🟡 ALERTA MEDIA: Patrón de Ausencia**
- **Condición:** ≥40% de las faltas son en el mismo día de la semana
- **Mensaje:** "El estudiante falta frecuentemente los días Lunes."
- **Acción recomendada:** "El X% de sus faltas son en Lunes. Investigar causa."
- **Color:** Amarillo (#ffc107)

### 4. **Filtros de Periodo Flexibles**
- **Hoy:** Solo el día actual
- **Esta semana:** Lunes a hoy
- **Este mes:** Desde el 1er día del mes hasta hoy
- **Este trimestre:** Trimestre actual
- **Año lectivo completo:** Todo el año lectivo (por defecto)
- **Personalizado:** Rango de fechas personalizado

### 5. **Visualización de Datos**
- **Círculo de progreso animado** con el porcentaje de asistencia
  - Verde (≥90%): Excelente
  - Amarillo (70-89%): Aceptable
  - Rojo (<70%): Crítico
- **Tarjetas de estadísticas** con iconos coloridos
- **Barra de progreso** para asistencia y faltas
- **Tabla de historial** con todas las asistencias del periodo
- **Badges coloridos** por estado de asistencia

### 6. **Exportación**
- **PDF:** Impresión nativa del navegador
- **Excel:** En desarrollo (próximamente)

---

## 🚀 Cómo Usar el Reporte Individual

### Método 1: Desde el Perfil del Estudiante

1. **Iniciar sesión** como administrador, docente o auxiliar
2. **Navegar** a Estudiantes → Buscar el estudiante
3. **Hacer clic** en el botón "Ver" (icono de ojo)
4. **Hacer clic** en el botón azul "Ver Reporte" (icono de gráfico de barras)
5. **Ver el reporte** con todos los datos del estudiante

### Método 2: Acceso Directo por URL

```
https://tu-dominio.com/SICA/reportes/reporte_individual.php?id=123
```

Donde `123` es el ID del estudiante.

---

## 📊 Interpretación de los Datos

### Ejemplo 1: Estudiante con Excelente Asistencia

```
Estudiante: Pérez García, Juan
DNI: 12345678
Nivel: Secundaria - 1° "A" - Mañana

┌─────────────────────────────────────┐
│        ● 95.3%                      │ ← Círculo verde
│   Asistencia Total                  │
└─────────────────────────────────────┘

✅ 180 Asistencias
⚠ 5 Tardanzas (45 min totales, 9 min promedio)
ℹ 2 Faltas Justificadas
❌ 0 Faltas Injustificadas

✅ No hay alertas para este estudiante
```

**Interpretación:**
- Excelente asistencia (95.3%)
- Pocas tardanzas (5 en todo el periodo)
- Todas las faltas justificadas
- **Acción:** Reconocimiento por perfect attendance o near-perfect

---

### Ejemplo 2: Estudiante en Riesgo de Perder Año

```
Estudiante: López Muñoz, María
DNI: 87654321
Nivel: Primaria - 4° "B" - Tarde

┌─────────────────────────────────────┐
│        ● 62.5%                      │ ← Círculo rojo
│   Asistencia Total                  │
└─────────────────────────────────────┘

✅ 125 Asistencias
⚠ 8 Tardanzas (120 min totales, 15 min promedio)
ℹ 3 Faltas Justificadas
❌ 62 Faltas Injustificadas (33.2%)

🔴 RIESGO DE PERDER AÑO
El estudiante tiene 33.2% de faltas injustificadas.
Supera el límite del 30%.

Intervención inmediata requerida.
Contactar a apoderado y tutoría.

🟠 Baja asistencia general
El estudiante solo asiste el 62.5% de los días.

Investigar causas. Revisar si necesita apoyo adicional.

🟠 Faltas consecutivas
El estudiante tiene 5 faltas consecutivas.

Contactar inmediatamente a la familia.
```

**Interpretación:**
- Asistencia crítica (62.5%)
- **Riesgo inminente de perder año**
- 5 faltas consecutivas (posible problema familiar o de salud)
- **Acción INMEDIATA:**
  1. Llamar a apoderado hoy mismo
  2. Citar a tutoría con padres
  3. Investigar situación familiar
  4. Considerar apoyo social o psicológico

---

### Ejemplo 3: Estudiante con Tardanzas Crónicas

```
Estudiante: Torres Vega, Carlos
DNI: 11223344
Nivel: Secundaria - 3° "A" - Mañana

┌─────────────────────────────────────┐
│        ● 82.1%                      │ ← Círculo amarillo
│   Asistencia Total                  │
└─────────────────────────────────────┘

✅ 164 Asistencias
⚠ 23 Tardanzas (345 min totales, 15 min promedio)
ℹ 8 Faltas Justificadas
❌ 5 Faltas Injustificadas (2.6%)

🟡 Exceso de tardanzas
El estudiante tiene 23 tardanzas en el periodo.

Considerar cambio de turno o revisar rutinas matutinas.

🟡 Patrón de ausencia detectado
El estudiante falta frecuentemente los días Lunes.

El 60% de sus faltas son en Lunes. Investigar causa.
```

**Interpretación:**
- Asistencia aceptable (82.1%)
- **Problema principal:** Tardanzas crónicas (23 en el periodo)
- Patrón claro: Faltas los lunes (posible fin de semana largo familiar)
- **Acción:**
  1. Conversar con estudiante y padres sobre punctualidad
  2. Si el problema es el horario, considerar cambio a turno tarde
  3. Investigar por qué falta los lunes (¿fiestas familiares domingos?)
  4. Establecer plan de mejora de punctualidad

---

## 🔧 Archivos del Módulo

### Archivos Principales

| Archivo | Descripción |
|---------|-------------|
| [reportes/reporte_individual.php](reportes/reporte_individual.php) | Vista principal del reporte individual |
| [reportes/ajax_reportes.php](reportes/ajax_reportes.php) | Endpoint AJAX para obtener datos de asistencia |

### Archivos Modificados

| Archivo | Cambios |
|---------|---------|
| [includes/sidebar.php](includes/sidebar.php:23,111-122) | Agregado enlace "Reportes" con submenú |
| [estudiantes/ver.php](estudiantes/ver.php:120-122) | Agregado botón "Ver Reporte" en perfil |

---

## 📈 Endpoints AJAX

### 1. `obtener_reporte_individual`

**URL:** `ajax_reportes.php?accion=obtener_reporte_individual`

**Parámetros:**
- `id_estudiante` (required): ID del estudiante
- `fecha_inicio` (optional): Fecha de inicio del periodo (YYYY-MM-DD)
- `fecha_fin` (optional): Fecha de fin del periodo (YYYY-MM-DD)

**Respuesta Exitosa:**
```json
{
    "success": true,
    "data": {
        "estudiante": {
            "id": 123,
            "dni": "12345678",
            "apellido_paterno": "Pérez",
            "apellido_materno": "García",
            "nombres": "Juan",
            "nombre_completo": "Pérez García, Juan",
            "genero": "M",
            "nivel": "Secundaria",
            "grado": "1°",
            "seccion": "A",
            "turno": "Mañana",
            "anio_lectivo": "2025-2026"
        },
        "periodo": {
            "fecha_inicio": "2025-03-01",
            "fecha_fin": "2025-12-20"
        },
        "estadisticas": {
            "total_dias": 200,
            "dias_asistidos": 180,
            "total_asistencias": 175,
            "total_tardanzas": 5,
            "total_faltas_justificadas": 2,
            "total_faltas_injustificadas": 0,
            "total_minutos_tardanza": 45,
            "porcentaje_asistencia": 95.3,
            "porcentaje_faltas_injustificadas": 0
        },
        "alertas": [
            {
                "tipo": "critico",
                "icono": "exclamation-triangle-fill",
                "titulo": "RIESGO DE PERDER AÑO",
                "mensaje": "El estudiante tiene 33.2% de faltas injustificadas...",
                "accion": "Intervención inmediata requerida...",
                "codigo": "riesgo_perder_año"
            }
        ],
        "asistencias": [
            {
                "id": 1234,
                "fecha": "2025-12-28",
                "hora_registro": "07:45:00",
                "minutos_tardanza": 5,
                "observaciones": "",
                "estado_codigo": "Tardanza",
                "estado_nombre": "Tardanza",
                "estado_abreviatura": "TAR",
                "estado_color": "#f59e0b",
                "estado_icono": "clock-fill",
                "conteo_asistencia": "1",
                "permite_tardanza": "1"
            }
        ]
    }
}
```

---

## 🎨 Colores y Estados de Asistencia

| Estado | Abreviatura | Color | Icono |
|--------|-------------|-------|-------|
| Asistencia | ASI | Verde (#10b981) | check-circle-fill |
| Tardanza | TAR | Amarillo (#f59e0b) | clock-fill |
| Tardanza Justificada | TJU | Azul (#3b82f6) | clock-history |
| Falta Justificada | FJU | Púrpura (#8b5cf6) | calendar-check |
| Falta Injustificada | FIN | Rojo (#ef4444) | calendar-x |
| Excusado | EXC | Cyan (#06b6d4) | calendar-x |
| Licencia | LIC | Rosa (#ec4899) | calendar-week |

---

## 🔐 Roles con Acceso

- ✅ **Admin**: Acceso completo a todos los reportes
- ✅ **Docente**: Puede ver reportes de sus estudiantes
- ✅ **Auxiliar**: Puede ver reportes de estudiantes
- ❌ **Estudiante**: No tiene acceso (verá su propio reporte en portal personal)
- ❌ **Apoderado**: No tiene acceso (verá reportes de sus hijos en portal personal)

---

## 🚧 Próximos Pasos (Fase 2)

### Reportes Prioritarios a Implementar

1. **Reporte por Sección**
   - Grid con todos los estudiantes de la sección
   - Resumen de asistencias por día
   - Identificación visual de estudiantes con alertas

2. **Reporte Consolidado**
   - Totales por nivel, grado, sección
   - Comparativas entre secciones
   - Gráficos de barras y torta

3. **Reporte de Alertas**
   - Lista de todos los estudiantes en riesgo
   - Priorización: Alta, Media, Baja
   - Acciones recomendadas por estudiante

4. **Dashboard de Asistencias**
   - Resumen ejecutivo del día
   - Comparación con días anteriores
   - Días con menor asistencia

---

## 📞 Soporte y Troubleshooting

### Problema: El reporte muestra "No hay registros en el periodo seleccionado"

**Causa:** El estudiante no tiene asistencias registradas en el rango de fechas.

**Solución:**
- Verificar que el estudiante tenga asistencias registradas
- Cambiar el periodo de fechas
- Verificar que el estudiante esté activo y con programación

### Problema: "Estudiante no encontrado o sin programación activa"

**Causa:** El estudiante no tiene una programación activa en el año lectivo actual.

**Solución:**
- Asignar el estudiante a una sección en el módulo de Programaciones
- Verificar que el año lectivo seleccionado sea correcto

### Problema: Las alertas no aparecen

**Causa:** El estudiante no tiene suficientes datos para generar alertas.

**Solución:**
- Seleccionar un periodo más largo (mes, trimestre, año completo)
- Verificar que haya suficientes registros de asistencia

---

## 📝 Registro de Cambios

### 2025-01-04 - Versión 1.0

**Características Implementadas:**
- ✅ Reporte individual de asistencia completo
- ✅ Estadísticas detalladas (8 métricas)
- ✅ Sistema de 7 alertas automáticas
- ✅ Filtros por periodo (5 predefinidos + personalizado)
- ✅ Círculo de progreso animado
- ✅ Visualización de datos con colores e iconos
- ✅ Historial completo de asistencias
- ✅ Integración con módulo de Estudiantes
- ✅ Exportación a PDF (impresión)

**Archivos Creados:**
- reportes/ajax_reportes.php (350 líneas)
- reportes/reporte_individual.php (450 líneas)

**Archivos Modificados:**
- includes/sidebar.php (enlaces de reportes)
- estudiantes/ver.php (botón "Ver Reporte")

---

## 🎓 Impacto en la Toma de Decisiones

### Casos de Uso Reales

#### 1. **Tutoría Mensual**
- El tutor revisa el reporte de cada estudiante
- Identifica rápidamente a los estudiantes en riesgo
- Planifica intervenciones preventivas

#### 2. **Reunión con Apoderados**
- El reporte se usa como evidencia objetiva
- Los apoderados ven visualmente el problema
- Se establecen metas de mejora claras

#### 3. **Comité de Retención**
- Se revisa el reporte de estudiantes en riesgo crítico
- Se toman decisiones informadas sobre promoción
- Se documentan intervenciones realizadas

#### 4. **Planificación de Clases**
- Los docentes identifican patrones de ausencia
- Evitan poner evaluaciones importantes en días de baja asistencia
- Planifican actividades de recuperación

---

**¿Listo para probar el reporte?**

Accede a: `https://tu-dominio.com/SICA/estudiantes/` → Selecciona un estudiante → "Ver" → "Ver Reporte"
