<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirAutenticacion();

$id = $_GET['id'] ?? 0;

if (!$id) {
    header('Location: index.php');
    exit;
}

// Obtener programación con información completa
$stmt = $pdo->prepare("
    SELECT
        p.id,
        p.id_seccion,
        p.id_anio_lectivo,
        p.id_tutor,
        p.id_auxiliar,
        p.capacidad,
        p.estado,
        p.observaciones,
        p.created_at,
        p.updated_at,
        t.nombre as turno,
        t.abreviatura as turno_abrev,
        t.hora_ingreso,
        t.hora_salida,
        t.tolerancia_minutos,
        s.id_nivel,
        n.nombre AS nivel_nombre,
        s.grado,
        s.seccion,
        a.anio,
        CONCAT(d.apellido_paterno, ' ', d.apellido_materno, ', ', d.nombres) AS tutor_nombre
    FROM programaciones p
    INNER JOIN secciones s ON s.id = p.id_seccion
    INNER JOIN turnos t ON t.id = p.id_turno
    INNER JOIN niveles n ON n.id = s.id_nivel
    INNER JOIN anios_lectivos a ON a.id = p.id_anio_lectivo
    LEFT JOIN docentes d ON d.id = p.id_tutor
    WHERE p.id = ?
");
$stmt->execute([$id]);
$programacion = $stmt->fetch();

if (!$programacion) {
    header('Location: index.php');
    exit;
}

// Obtener estudiantes asignados
$stmt = $pdo->prepare("
    SELECT
        pe.id AS asignacion_id,
        pe.fecha_asignacion,
        pe.estado AS estudiante_estado,
        e.id,
        e.dni,
        e.apellido_paterno,
        e.apellido_materno,
        e.nombres,
        e.genero
    FROM programaciones_estudiantes pe
    INNER JOIN estudiantes e ON e.id = pe.id_estudiante
    WHERE pe.id_programacion = ? AND pe.estado = 'activo'
    ORDER BY e.apellido_paterno, e.apellido_materno, e.nombres
");
$stmt->execute([$id]);
$estudiantes = $stmt->fetchAll();

// Obtener áreas académicas asignadas
$stmt = $pdo->prepare("
    SELECT
        pda.id,
        pda.fecha_asignacion,
        aa.area,
        CONCAT(doc.apellido_paterno, ' ', doc.apellido_materno, ', ', doc.nombres) AS docente_nombre
    FROM programaciones_docentes_areas pda
    INNER JOIN areas_academicas aa ON aa.id = pda.id_area_academica
    INNER JOIN docentes doc ON doc.id = pda.id_docente
    WHERE pda.id_programacion = ? AND pda.estado = 'activo'
    ORDER BY aa.area
");
$stmt->execute([$id]);
$areas = $stmt->fetchAll();

// Obtener auxiliar asignado (directo de programaciones)
$stmt = $pdo->prepare("
    SELECT
        aux.id,
        aux.dni,
        aux.email,
        aux.telefono,
        CONCAT(aux.apellido_paterno, ' ', aux.apellido_materno, ', ', aux.nombres) AS auxiliar_nombre
    FROM auxiliares aux
    WHERE aux.id = (SELECT id_auxiliar FROM programaciones WHERE id = ?)
");
$stmt->execute([$id]);
$auxiliar = $stmt->fetch();

// Obtener apoderados de los estudiantes
$apoderados_estudiantes = [];
if (!empty($estudiantes)) {
    $ids_estudiantes = array_column($estudiantes, 'id');
    $placeholders = str_repeat('?,', count($ids_estudiantes) - 1) . '?';

    $stmt = $pdo->prepare("
        SELECT
            ea.id_estudiante,
            CONCAT(a.apellido_paterno, ' ', a.apellido_materno, ', ', a.nombres) AS apoderado_nombre,
            a.telefono,
            a.email,
            ea.parentesco
        FROM estudiantes_apoderados ea
        INNER JOIN apoderados a ON a.id = ea.id_apoderado
        WHERE ea.id_estudiante IN ($placeholders)
        AND ea.estado = 'activo'
        ORDER BY a.apellido_paterno
    ");
    $stmt->execute($ids_estudiantes);
    $result = $stmt->fetchAll();

    foreach ($result as $row) {
        $apoderados_estudiantes[$row['id_estudiante']][] = $row;
    }
}

$porcentaje_ocupacion = $programacion['capacidad'] > 0
    ? round((count($estudiantes) / $programacion['capacidad']) * 100)
    : 0;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Ver Programación - SICA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
            <div class="d-flex align-items-center">
                <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                    <i class="bi bi-list fs-4"></i>
                </button>
                <div>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-1">
                            <li class="breadcrumb-item"><a href="index.php" class="text-decoration-none">Programaciones</a></li>
                            <li class="breadcrumb-item active">Ver</li>
                        </ol>
                    </nav>
                    <h3 class="mb-0">
                        <?= htmlspecialchars($programacion['nivel_nombre']) ?> -
                        <?= htmlspecialchars($programacion['grado']) ?>°
                        <strong><?= htmlspecialchars($programacion['seccion']) ?></strong>
                    </h3>
                </div>
            </div>
            <div>
                <a href="asignar_estudiantes.php?id=<?= $id ?>" class="btn btn-success">
                    <i class="bi bi-person-plus me-2"></i>Asignar Estudiantes
                </a>
                <a href="editar.php?id=<?= $id ?>" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Editar
                </a>
                <a href="eliminar.php?id=<?= $id ?>" class="btn btn-danger"
                   onclick="return confirm('¿Estás seguro de que deseas eliminar esta programación?')">
                    <i class="bi bi-trash me-2"></i>Eliminar
                </a>
            </div>
        </div>

        <?php if (isset($_GET['exito'])): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle me-2"></i>
                Programación creada correctamente. Ahora puedes asignar estudiantes y áreas académicas.
            </div>
        <?php endif; ?>

        <!-- Información Principal -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body text-center">
                        <i class="bi bi-calendar-range fs-1 text-primary mb-2"></i>
                        <h6 class="text-muted">Año Lectivo</h6>
                        <h5><?= htmlspecialchars($programacion['anio']) ?></h5>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body text-center">
                        <i class="bi bi-sunrise fs-1 text-warning mb-2"></i>
                        <h6 class="text-muted">Turno</h6>
                        <h5><?= ucfirst($programacion['turno']) ?></h5>
                        <small class="text-muted">
                            <?= date('H:i', strtotime($programacion['hora_ingreso'] ?? '00:00')) ?>
                            -
                            <?= date('H:i', strtotime($programacion['hora_salida'] ?? '00:00')) ?>
                        </small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body text-center">
                        <i class="bi bi-people fs-1 text-success mb-2"></i>
                        <h6 class="text-muted">Estudiantes</h6>
                        <h5><?= count($estudiantes) ?> / <?= $programacion['capacidad'] ?></h5>
                        <div class="progress mt-2" style="height: 6px;">
                            <?php if ($porcentaje_ocupacion >= 90): ?>
                                <div class="progress-bar bg-danger" style="width: <?= $porcentaje_ocupacion ?>%"></div>
                            <?php elseif ($porcentaje_ocupacion >= 70): ?>
                                <div class="progress-bar bg-warning" style="width: <?= $porcentaje_ocupacion ?>%"></div>
                            <?php else: ?>
                                <div class="progress-bar bg-success" style="width: <?= $porcentaje_ocupacion ?>%"></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body text-center">
                        <i class="bi bi-book fs-1 text-info mb-2"></i>
                        <h6 class="text-muted">Áreas</h6>
                        <h5><?= count($areas) ?></h5>
                        <small class="text-muted">asignadas</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pestañas de Información -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-bottom">
                <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tablist">
                    <li class="nav-item">
                        <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#estudiantes" type="button">
                            <i class="bi bi-people me-2"></i>Estudiantes (<?= count($estudiantes) ?>)
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#areas" type="button">
                            <i class="bi bi-book me-2"></i>Áreas Académicas (<?= count($areas) ?>)
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#personal" type="button">
                            <i class="bi bi-person-workspace me-2"></i>Personal
                        </button>
                    </li>
                </ul>
            </div>

            <div class="card-body">
                <div class="tab-content" id="myTabContent">

                    <!-- Tab: Estudiantes -->
                    <div class="tab-pane fade show active" id="estudiantes">
                        <?php if (empty($estudiantes)): ?>
                            <div class="text-center py-5">
                                <i class="bi bi-person-x fs-1 text-muted"></i>
                                <p class="text-muted mt-3">
                                    No hay estudiantes asignados.
                                    <a href="asignar_estudiantes.php?id=<?= $id ?>" class="btn btn-sm btn-success ms-2">
                                        <i class="bi bi-plus-circle me-1"></i>Asignar Estudiantes
                                    </a>
                                </p>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>DNI</th>
                                            <th>Apellidos y Nombres</th>
                                            <th>Género</th>
                                            <th>Apoderados</th>
                                            <th>Fecha Asignación</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($estudiantes as $est): ?>
                                            <tr>
                                                <td><code><?= htmlspecialchars($est['dni']) ?></code></td>
                                                <td>
                                                    <strong><?= htmlspecialchars($est['apellido_paterno']) ?></strong>
                                                    <?= htmlspecialchars($est['apellido_materno']) ?>,
                                                    <?= htmlspecialchars($est['nombres']) ?>
                                                </td>
                                                <td>
                                                    <span class="badge bg-light text-dark">
                                                        <?= $est['genero'] == 'M' ? 'Masculino' : 'Femenino' ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if (isset($apoderados_estudiantes[$est['id']])): ?>
                                                        <?php foreach ($apoderados_estudiantes[$est['id']] as $apod): ?>
                                                            <div class="small">
                                                                <i class="bi bi-person-heart text-danger"></i>
                                                                <?= htmlspecialchars($apod['apoderado_nombre']) ?>
                                                                <br>
                                                                <small class="text-muted">
                                                                    <?= htmlspecialchars($apod['parentesco']) ?> -
                                                                    <?= htmlspecialchars($apod['telefono'] ?? 'N/A') ?>
                                                                </small>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <span class="text-muted small">Sin apoderados</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <small class="text-muted">
                                                        <?= date('d/m/Y', strtotime($est['fecha_asignacion'])) ?>
                                                    </small>
                                                </td>
                                                <td>
                                                    <a href="../estudiantes/ver.php?id=<?= $est['id'] ?>"
                                                       class="btn btn-sm btn-outline-primary" title="Ver estudiante">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Tab: Áreas Académicas -->
                    <div class="tab-pane fade" id="areas">
                        <?php if (empty($areas)): ?>
                            <div class="text-center py-5">
                                <i class="bi bi-book-x fs-1 text-muted"></i>
                                <p class="text-muted mt-3">
                                    No hay áreas académicas asignadas.
                                    <a href="asignar_docentes.php?id=<?= $id ?>" class="btn btn-sm btn-primary ms-2">
                                        <i class="bi bi-plus-circle me-1"></i>Asignar Áreas
                                    </a>
                                </p>
                            </div>
                        <?php else: ?>
                            <div class="row">
                                <?php foreach ($areas as $area): ?>
                                    <div class="col-md-6 col-lg-4 mb-3">
                                        <div class="card border">
                                            <div class="card-body">
                                                <h6 class="card-title mb-2">
                                                    <i class="bi bi-bookmark text-primary me-2"></i>
                                                    <?= htmlspecialchars($area['area']) ?>
                                                </h6>
                                                <p class="card-text mb-1">
                                                    <i class="bi bi-person-workspace text-secondary me-2"></i>
                                                    <?= htmlspecialchars($area['docente_nombre']) ?>
                                                </p>
                                                <small class="text-muted">
                                                    Asignado: <?= date('d/m/Y', strtotime($area['fecha_asignacion'])) ?>
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="text-center mt-3">
                                <a href="asignar_docentes.php?id=<?= $id ?>" class="btn btn-primary">
                                    <i class="bi bi-plus-circle me-2"></i>Asignar Más Áreas
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Tab: Personal -->
                    <div class="tab-pane fade" id="personal">
                        <div class="row">
                            <!-- Tutor -->
                            <div class="col-md-6 mb-4">
                                <h6 class="mb-3">
                                    <i class="bi bi-person-workspace text-primary me-2"></i>Tutor de la Sección
                                </h6>
                                <?php if ($programacion['tutor_nombre']): ?>
                                    <div class="card">
                                        <div class="card-body">
                                            <h5 class="card-title mb-1"><?= htmlspecialchars($programacion['tutor_nombre']) ?></h5>
                                            <p class="card-text">
                                                <small class="text-muted">Docente principal de la sección</small>
                                            </p>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-warning">
                                        <i class="bi bi-exclamation-triangle me-2"></i>
                                        No hay tutor asignado
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Auxiliar -->
                            <div class="col-md-6 mb-4">
                                <h6 class="mb-3">
                                    <i class="bi bi-clipboard-data text-info me-2"></i>Auxiliar de Educación
                                </h6>
                                <?php if (empty($auxiliar)): ?>
                                    <div class="alert alert-info">
                                        <i class="bi bi-info-circle me-2"></i>
                                        No hay auxiliar asignado
                                    </div>
                                <?php else: ?>
                                    <div class="card">
                                        <div class="card-body">
                                            <h6 class="mb-1"><?= htmlspecialchars($auxiliar['auxiliar_nombre']) ?></h6>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    <i class="bi bi-phone me-1"></i><?= htmlspecialchars($auxiliar['telefono'] ?? 'N/A') ?>
                                                    <i class="bi bi-envelope ms-2 me-1"></i><?= htmlspecialchars($auxiliar['email'] ?? 'N/A') ?>
                                                </small>
                                            </p>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    <?php include '../includes/layout_scripts.php'; ?>
</body>
</html>
