<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirAutenticacion();

$id = $_GET['id'] ?? 0;

if (!$id) {
    header('Location: index.php');
    exit;
}

// Obtener programación
$stmt = $pdo->prepare("
    SELECT
        p.id,
        p.id_seccion,
        p.id_anio_lectivo,
        p.id_tutor,
        p.id_auxiliar,
        p.capacidad,
        p.estado,
        p.observaciones,
        p.created_at,
        p.updated_at,
        t.nombre as turno,
        t.abreviatura as turno_abrev,
        t.hora_ingreso,
        t.hora_salida,
        t.tolerancia_minutos,
        s.id_nivel,
        n.nombre AS nivel_nombre,
        s.grado,
        s.seccion,
        a.anio
    FROM programaciones p
    INNER JOIN secciones s ON s.id = p.id_seccion
    INNER JOIN turnos t ON t.id = p.id_turno
    INNER JOIN niveles n ON n.id = s.id_nivel
    INNER JOIN anios_lectivos a ON a.id = p.id_anio_lectivo
    WHERE p.id = ?
");
$stmt->execute([$id]);
$programacion = $stmt->fetch();

if (!$programacion) {
    header('Location: index.php');
    exit;
}

// Obtener docentes para tutor
$docentes = query("
    SELECT d.id, d.dni,
           CONCAT(d.apellido_paterno, ' ', d.apellido_materno, ', ', d.nombres) AS nombre
    FROM docentes d
    WHERE d.estado = 'activo'
    ORDER BY d.apellido_paterno, d.apellido_materno
")->fetchAll();

// Obtener auxiliares
$auxiliares = query("
    SELECT a.id, a.dni,
           CONCAT(a.apellido_paterno, ' ', a.apellido_materno, ', ', a.nombres) AS nombre
    FROM auxiliares a
    WHERE a.estado = 'activo'
    ORDER BY a.apellido_paterno, a.apellido_materno
")->fetchAll();

$errores = [];
$exito = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_tutor = $_POST['id_tutor'] ?? null;
    $id_auxiliar = $_POST['id_auxiliar'] ?? null;
    $estado = $_POST['estado'] ?? 'activo';
    $observaciones = $_POST['observaciones'] ?? null;

    if (empty($errores)) {
        try {
            $stmt = $pdo->prepare("
                UPDATE programaciones
                SET id_tutor = ?, id_auxiliar = ?, estado = ?, observaciones = ?, updated_at = NOW()
                WHERE id = ?
            ");

            $stmt->execute([
                $id_tutor ?: null,
                $id_auxiliar ?: null,
                $estado,
                $observaciones,
                $id
            ]);

            $exito = true;

        } catch (Exception $e) {
            $errores[] = $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Editar Programación - SICA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
            <div class="d-flex align-items-center">
                <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                    <i class="bi bi-list fs-4"></i>
                </button>
                <div>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-1">
                            <li class="breadcrumb-item"><a href="index.php" class="text-decoration-none">Programaciones</a></li>
                            <li class="breadcrumb-item active">Editar</li>
                        </ol>
                    </nav>
                    <h3 class="mb-0">Editar Programación</h3>
                    <p class="text-muted mb-0">
                        <?= htmlspecialchars($programacion['nivel_nombre']) ?> -
                        <?= htmlspecialchars($programacion['grado']) ?>°
                        <strong><?= htmlspecialchars($programacion['seccion']) ?></strong>
                    </p>
                </div>
            </div>
            <a href="ver.php?id=<?= $id ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Volver
            </a>
        </div>

        <?php if ($exito): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle me-2"></i>
                Programación actualizada correctamente.
            </div>
        <?php endif; ?>

        <?php if (!empty($errores)): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Error:</strong>
                <ul class="mb-0 mt-2">
                    <?php foreach ($errores as $error): ?>
                        <li><?= htmlspecialchars($error) ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <form method="POST">
                            <!-- Información de la Sección (Solo lectura) -->
                            <div class="alert alert-info mb-4">
                                <div class="row">
                                    <div class="col-md-3">
                                        <strong>Nivel:</strong><br>
                                        <?= htmlspecialchars($programacion['nivel_nombre']) ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Grado:</strong><br>
                                        <?= htmlspecialchars($programacion['grado']) ?>°
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Sección:</strong><br>
                                        <?= htmlspecialchars($programacion['seccion']) ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Año:</strong><br>
                                        <?= htmlspecialchars($programacion['anio']) ?>
                                    </div>
                                </div>
                            </div>

                            <!-- Tutor -->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Docente Tutor</label>
                                <select name="id_tutor" class="form-select">
                                    <option value="">Sin tutor</option>
                                    <?php foreach ($docentes as $doc): ?>
                                        <option value="<?= $doc['id'] ?>" <?= $programacion['id_tutor'] == $doc['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($doc['nombre']) ?> (DNI: <?= $doc['dni'] ?>)
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <small class="text-muted">El tutor será el docente principal de la sección</small>
                            </div>

                            <!-- Auxiliar -->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Auxiliar de Educación</label>
                                <select name="id_auxiliar" class="form-select">
                                    <option value="">Sin auxiliar</option>
                                    <?php foreach ($auxiliares as $aux): ?>
                                        <option value="<?= $aux['id'] ?>" <?= $programacion['id_auxiliar'] == $aux['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($aux['nombre']) ?> (DNI: <?= $aux['dni'] ?>)
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <small class="text-muted">El auxiliar asignado registrará las asistencias de esta sección</small>
                            </div>

                            <!-- Turno y Capacidad (Solo lectura - se gestionan en Turnos y Secciones) -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Turno</label>
                                    <input type="text" class="form-control bg-light"
                                           value="<?= htmlspecialchars($programacion['turno']) ?>"
                                           readonly>
                                    <small class="text-muted">
                                        <i class="bi bi-info-circle me-1"></i>
                                        Este dato se gestiona en <a href="../config/turnos.php" class="text-decoration-none">Gestión de Turnos</a>
                                    </small>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Horario</label>
                                    <input type="text" class="form-control bg-light"
                                           value="<?= date('H:i', strtotime($programacion['hora_ingreso'])) ?> - <?= date('H:i', strtotime($programacion['hora_salida'])) ?>"
                                           readonly>
                                    <small class="text-muted">
                                        <i class="bi bi-info-circle me-1"></i>
                                        Gestión de Turnos
                                    </small>
                                </div>
                            </div>

                            <!-- Capacidad (Solo lectura - se gestiona en Secciones) -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Capacidad Máxima</label>
                                    <input type="text" class="form-control bg-light"
                                           value="<?= htmlspecialchars($programacion['capacidad']) ?>"
                                           readonly>
                                    <small class="text-muted">
                                        <i class="bi bi-info-circle me-1"></i>
                                        Este dato se gestiona en <a href="../config/secciones.php" class="text-decoration-none">Gestión de Secciones</a>
                                    </small>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Tolerancia</label>
                                    <input type="text" class="form-control bg-light"
                                           value="<?= $programacion['tolerancia_minutos'] ?? 15 ?> minutos"
                                           readonly>
                                    <small class="text-muted">
                                        <i class="bi bi-info-circle me-1"></i>
                                        Gestión de Turnos
                                    </small>
                                </div>
                            </div>

                            <!-- Estado -->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Estado <span class="text-danger">*</span></label>
                                <select name="estado" class="form-select" required>
                                    <option value="activo" <?= $programacion['estado'] == 'activo' ? 'selected' : '' ?>>Activo</option>
                                    <option value="inactivo" <?= $programacion['estado'] == 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
                                    <option value="finalizado" <?= $programacion['estado'] == 'finalizado' ? 'selected' : '' ?>>Finalizado</option>
                                </select>
                            </div>

                            <!-- Observaciones -->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Observaciones</label>
                                <textarea name="observaciones" class="form-control" rows="3"><?= htmlspecialchars($programacion['observaciones'] ?? '') ?></textarea>
                            </div>

                            <!-- Botones -->
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="bi bi-save me-2"></i>Guardar Cambios
                                </button>
                                <a href="ver.php?id=<?= $id ?>" class="btn btn-outline-secondary btn-lg">
                                    <i class="bi bi-x-circle me-2"></i>Cancelar
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Sidebar derecho con enlaces rápidos -->
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-primary text-white">
                        <h6 class="mb-0"><i class="bi bi-link-45deg me-2"></i>Acciones Rápidas</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="asignar_estudiantes.php?id=<?= $id ?>" class="btn btn-outline-primary">
                                <i class="bi bi-person-plus me-2"></i>Gestionar Estudiantes
                            </a>
                            <a href="asignar_docentes.php?id=<?= $id ?>" class="btn btn-outline-primary">
                                <i class="bi bi-book me-2"></i>Gestionar Áreas
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-warning text-dark">
                        <h6 class="mb-0"><i class="bi bi-exclamation-triangle me-2"></i>Advertencia</h6>
                    </div>
                    <div class="card-body">
                        <p class="mb-0">
                            Al cambiar el estado a <strong>Inactivo</strong> o <strong>Finalizado</strong>,
                            la programación no estará disponible para nuevas asignaciones,
                            pero los datos históricos se mantendrán.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include '../includes/layout_scripts.php'; ?>
</body>
</html>
