<?php
require_once 'config/db.php';
require_once 'config/functions.php';

// Verificar que el usuario esté autenticado
requerirAutenticacion();

$usuario_id = $_SESSION['usuario_id'];
$errores = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';

    if ($accion === 'actualizar_perfil') {
        $nombre_actual = sanitizar($_POST['nombre_actual'] ?? '');
        $email = sanitizar($_POST['email'] ?? '');

        if (empty($nombre_actual) || empty($email)) {
            $errores[] = 'Complete todos los campos';
        } else {
            // Actualizar nombre en la tabla correspondiente según el rol
            query("UPDATE usuarios SET usuario = ? WHERE id = ?", [$nombre_actual, $usuario_id]);

            // Actualizar email si el usuario tiene email asociado
            if (!empty($email)) {
                // Aquí podrías agregar lógica para actualizar email en tabla correspondiente
                // según el rol del usuario
            }

            setAlerta('success', 'Perfil actualizado correctamente');
            header('Location: perfil.php');
            exit;
        }
    } elseif ($accion === 'cambiar_password') {
        $password_actual = $_POST['password_actual'] ?? '';
        $password_nuevo = $_POST['password_nuevo'] ?? '';
        $password_confirmar = $_POST['password_confirmar'] ?? '';

        if (empty($password_actual) || empty($password_nuevo) || empty($password_confirmar)) {
            $errores[] = 'Complete todos los campos';
        } elseif ($password_nuevo !== $password_confirmar) {
            $errores[] = 'La nueva contraseña no coincide con la confirmación';
        } elseif (strlen($password_nuevo) < 6) {
            $errores[] = 'La nueva contraseña debe tener al menos 6 caracteres';
        } else {
            // Verificar contraseña actual
            $usuario = query("SELECT * FROM usuarios WHERE id = ?", [$usuario_id])->fetch();

            if (password_verify($password_actual, $usuario['password'])) {
                // Actualizar contraseña
                $hash = password_hash($password_nuevo, PASSWORD_DEFAULT);
                query("UPDATE usuarios SET password = ? WHERE id = ?", [$hash, $usuario_id]);
                setAlerta('success', 'Contraseña cambiada correctamente');
                header('Location: perfil.php');
                exit;
            } else {
                $errores[] = 'La contraseña actual es incorrecta';
            }
        }
    }
}

// Obtener datos del usuario actual
$stmt = query("SELECT * FROM usuarios WHERE id = ?", [$usuario_id]);
if ($stmt === false) {
    die('Error al consultar el usuario');
}

$datos_usuario = $stmt->fetch(PDO::FETCH_ASSOC);

if ($datos_usuario === false) {
    die('Usuario no encontrado');
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Mi Perfil</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include 'includes/layout_elems.php'; ?>

    <!-- Botón hamburguesa para móvil -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="d-flex align-items-center">
            <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                <i class="bi bi-list fs-4"></i>
            </button>
            <div>
                <h3 class="mb-1">Mi Perfil</h3>
                <p class="text-muted mb-0">Gestiona tu cuenta y seguridad</p>
            </div>
        </div>
        <a href="dashboard.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Volver</a>
    </div>

        <?php if ($alerta = getAlerta()): ?>
            <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show"><?= $alerta['mensaje'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>

        <?php if (!empty($errores)): ?>
            <div class="alert alert-danger">
                <?php foreach ($errores as $error): ?>
                    <?= $error ?><br>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-4">
                <div class="content-card text-center">
                    <div class="mb-3">
                        <i class="bi bi-person-circle" style="font-size: 80px; color: #6c757d;"></i>
                    </div>
                    <h5><?= htmlspecialchars($datos_usuario['usuario']) ?></h5>
                    <p class="text-muted mb-2">
                        <span class="badge bg-info"><?= nombreRol($datos_usuario['rol']) ?></span>
                    </p>
                    <p class="text-muted mb-0">
                        Estado: <span class="badge bg-<?= $datos_usuario['estado'] === 'activo' ? 'success' : 'secondary' ?>"><?= $datos_usuario['estado'] ?></span>
                    </p>
                    <hr>
                    <small class="text-muted">
                        <i class="bi bi-calendar3 me-1"></i> Creado: <?= $datos_usuario['fecha_registro'] ? date('d/m/Y', strtotime($datos_usuario['fecha_registro'])) : 'N/A' ?>
                    </small>
                </div>
            </div>

            <div class="col-md-8">
                <div class="content-card mb-3">
                    <h5 class="mb-3"><i class="bi bi-person-gear me-2"></i>Información de la Cuenta</h5>
                    <form method="POST">
                        <input type="hidden" name="accion" value="actualizar_perfil">
                        <div class="mb-3">
                            <label class="form-label">Usuario</label>
                            <input type="text" name="nombre_actual" class="form-control" value="<?= htmlspecialchars($datos_usuario['usuario']) ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" placeholder="correo@ejemplo.com">
                            <small class="text-muted">Opcional: Used para notificaciones</small>
                        </div>
                        <button type="submit" class="btn btn-primary"><i class="bi bi-save me-2"></i>Actualizar Perfil</button>
                    </form>
                </div>

                <div class="content-card">
                    <h5 class="mb-3"><i class="bi bi-shield-lock me-2"></i>Cambiar Contraseña</h5>
                    <form method="POST">
                        <input type="hidden" name="accion" value="cambiar_password">
                        <div class="mb-3">
                            <label class="form-label">Contraseña Actual</label>
                            <input type="password" name="password_actual" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nueva Contraseña</label>
                            <input type="password" name="password_nuevo" class="form-control" minlength="6" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Confirmar Nueva Contraseña</label>
                            <input type="password" name="password_confirmar" class="form-control" minlength="6" required>
                        </div>
                        <button type="submit" class="btn btn-warning"><i class="bi bi-key me-2"></i>Cambiar Contraseña</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php include 'includes/layout_scripts.php'; ?>
</body>
</html>
