<?php
/**
 * Generar plantilla de Excel para importación de estudiantes
 */

require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

// Cargar SimpleXLSXGen para generar archivos Excel
require_once '../vendor/shuchkin/simplexlsxgen/src/SimpleXLSXGen.php';

// Crear datos de la plantilla
$datos = [
    // Encabezados
    [
        'DNI *',
        'Apellido Paterno *',
        'Apellido Materno *',
        'Nombres *',
        'Fecha Nacimiento * (dd/mm/aaaa)',
        'Genero * (M/F)',
        'Telefono',
        'Direccion'
    ],
    // Ejemplo 1
    [
        '12345678',
        'Perez',
        'Gonzales',
        'Juan Carlos',
        '15/05/2010',
        'M',
        '999888777',
        'Av. Principal 123, Lima'
    ],
    // Ejemplo 2
    [
        '87654321',
        'Rodriguez',
        'Lopez',
        'Maria Fernanda',
        '20/08/2012',
        'F',
        '987654321',
        'Jr. Secundaria 456, Lima'
    ]
];

// Generar archivo Excel
$xlsx = \Shuchkin\SimpleXLSXGen::fromArray($datos);

// Enviar el archivo
$xlsx->downloadAs('plantilla_estudiantes_sica.xlsx');
