<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

// Filtros
$busqueda = $_GET['busqueda'] ?? '';
$estado_filtro = $_GET['estado'] ?? '';

// Construir consulta
$where = ["1=1"];
$params = [];

if ($estado_filtro) {
    $where[] = "e.estado = :estado";
    $params['estado'] = $estado_filtro;
}

if ($busqueda) {
    $where[] = "(e.dni LIKE :busqueda1 OR e.nombres LIKE :busqueda2 OR e.apellido_paterno LIKE :busqueda3 OR e.apellido_materno LIKE :busqueda4)";
    $busqueda_param = "%$busqueda%";
    $params['busqueda1'] = $busqueda_param;
    $params['busqueda2'] = $busqueda_param;
    $params['busqueda3'] = $busqueda_param;
    $params['busqueda4'] = $busqueda_param;
}

$sql = "SELECT e.*, u.usuario
        FROM estudiantes e
        LEFT JOIN usuarios u ON e.id_usuario = u.id
        WHERE " . implode(' AND ', $where) . "
        ORDER BY e.apellido_paterno, e.apellido_materno";

$stmt = query($sql, $params);
$estudiantes = $stmt ? $stmt->fetchAll() : [];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Gestión de Estudiantes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <!-- Botón hamburguesa para móvil -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="d-flex align-items-center">
            <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                <i class="bi bi-list fs-4"></i>
            </button>
            <div>
                <h3 class="mb-1">Gestión de Estudiantes</h3>
                <p class="text-muted mb-0">Registro de estudiantes del sistema</p>
            </div>
        </div>
        <div class="btn-group">
            <a href="crear.php" class="btn btn-primary">
                <i class="bi bi-plus-circle me-2"></i>Nuevo Estudiante
            </a>
            <a href="importar.php" class="btn btn-success">
                <i class="bi bi-file-earmark-excel me-2"></i>Importar
            </a>
        </div>
    </div>

        <div class="content-card">
            <!-- Filtros -->
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-4">
                    <label class="form-label">Buscar</label>
                    <input type="text" name="busqueda" class="form-control" placeholder="DNI o nombres..." value="<?= htmlspecialchars($busqueda) ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Estado</label>
                    <select name="estado" class="form-select">
                        <option value="">Todos</option>
                        <option value="activo" <?= $estado_filtro === 'activo' ? 'selected' : '' ?>>Activo</option>
                        <option value="retirado" <?= $estado_filtro === 'retirado' ? 'selected' : '' ?>>Retirado</option>
                        <option value="trasladado" <?= $estado_filtro === 'trasladado' ? 'selected' : '' ?>>Trasladado</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-funnel-fill me-2"></i>Filtrar
                    </button>
                </div>
            </form>

            <!-- Tabla -->
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>DNI</th>
                            <th>Apellidos y Nombres</th>
                            <th>Fecha Nacimiento</th>
                            <th>Género</th>
                            <th>Teléfono</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($estudiantes)): ?>
                            <tr>
                                <td colspan="7" class="text-center py-4 text-muted">
                                    <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                    No se encontraron estudiantes
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($estudiantes as $est): ?>
                                <tr>
                                    <td><code><?= htmlspecialchars($est['dni']) ?></code></td>
                                    <td>
                                        <strong><?= htmlspecialchars($est['apellido_paterno'] . ' ' . $est['apellido_materno']) ?></strong><br>
                                        <small class="text-muted"><?= htmlspecialchars($est['nombres']) ?></small>
                                    </td>
                                    <td><?= formatearFecha($est['fecha_nacimiento']) ?></td>
                                    <td><?= $est['genero'] === 'M' ? 'Masculino' : 'Femenino' ?></td>
                                    <td><?= htmlspecialchars($est['telefono'] ?? '-') ?></td>
                                    <td>
                                        <?php if ($est['estado'] === 'activo'): ?>
                                            <span class="badge bg-success">Activo</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary"><?= ucfirst($est['estado']) ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="descargar_qr.php?id=<?= $est['id'] ?>" class="btn btn-dark" title="Descargar QR">
                                                <i class="bi bi-qr-code"></i>
                                            </a>
                                            <a href="ver.php?id=<?= $est['id'] ?>" class="btn btn-info" title="Ver">
                                                <i class="bi bi-eye-fill"></i>
                                            </a>
                                            <a href="editar.php?id=<?= $est['id'] ?>" class="btn btn-warning" title="Editar">
                                                <i class="bi bi-pencil-fill"></i>
                                            </a>
                                            <button onclick="eliminar(<?= $est['id'] ?>)" class="btn btn-danger" title="Eliminar">
                                                <i class="bi bi-trash-fill"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if (!empty($estudiantes)): ?>
                <div class="mt-3 text-muted">
                    <small>Total: <?= count($estudiantes) ?> estudiante(s)</small>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php
    $extra_scripts = <<<HTML
    <script>
        function eliminar(id) {
            if (confirm('¿Está seguro de eliminar este estudiante?')) {
                window.location.href = 'eliminar.php?id=' + id;
            }
        }
    </script>
    HTML;
    include '../includes/layout_scripts.php';
    ?>
</body>
</html>
