<?php
/**
 * Generar código QR como imagen para estudiantes
 * Uso: generar_qr.php?dni=12345678&formato=png
 */

require_once '../config/db.php';
require_once '../config/functions.php';

$dni = $_GET['dni'] ?? '';
$formato = strtolower($_GET['formato'] ?? 'png');
$tamanio = intval($_GET['tamanio'] ?? 200); // Tamaño en píxeles

if (!$dni) {
    header('HTTP/1.0 400 Bad Request');
    exit('DNI es requerido');
}

// Validar formato
if (!in_array($formato, ['png', 'jpg', 'jpeg'])) {
    $formato = 'png';
}

// Obtener datos del estudiante
$estudiante = query("SELECT id, dni, nombres, apellido_paterno, apellido_materno
                    FROM estudiantes WHERE dni = ?", [$dni])->fetch();

if (!$estudiante) {
    header('HTTP/1.0 404 Not Found');
    exit('Estudiante no encontrado');
}

// Generar código QR usando API de QR Server
$qr_data = $dni; // El QR contiene solo el DNI
$api_url = "https://api.qrserver.com/v1/create-qr-code/?size={$tamanio}x{$tamanio}&data=" . urlencode($qr_data) . "&ecc=H&bgcolor=ffffff";

// Usar cURL en lugar de file_get_contents
$ch = curl_init($api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$qr_image = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($qr_image === false || $http_code != 200) {
    // Si falla la API, generar un QR simple con GD
    $qr = imagecreatetruecolor($tamanio, $tamanio);
    $blanco = imagecolorallocate($qr, 255, 255, 255);
    $negro = imagecolorallocate($qr, 0, 0, 0);
    imagefill($qr, 0, 0, $blanco);

    // Dibujar un marco simple
    imagerectangle($qr, 10, 10, $tamanio - 10, $tamanio - 10, $negro);

    // Texto DNI
    $texto = 'DNI: ' . $dni;
    $font = 5;
    $x = ($tamanio - imagefontwidth($font) * strlen($texto)) / 2;
    $y = ($tamanio - imagefontheight($font)) / 2;
    imagestring($qr, $font, $x, $y, $texto, $negro);

    // Enviar imagen
    if ($formato === 'jpg' || $formato === 'jpeg') {
        header('Content-Type: image/jpeg');
        imagejpeg($qr, null, 90);
    } else {
        header('Content-Type: image/png');
        imagepng($qr);
    }
    imagedestroy($qr);
    exit;
}

// Devolver la imagen directamente de la API
header('Content-Type: image/png');
echo $qr_image;
