<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$id = intval($_GET['id'] ?? 0);

if (!$id) {
    setAlerta('danger', 'ID de estudiante no válido');
    header('Location: index.php');
    exit;
}

// Obtener estudiante
$estudiante = query("SELECT e.*, u.id AS id_usuario
                    FROM estudiantes e
                    LEFT JOIN usuarios u ON e.id_usuario = u.id
                    WHERE e.id = ?", [$id])->fetch();

if (!$estudiante) {
    setAlerta('danger', 'Estudiante no encontrado');
    header('Location: index.php');
    exit;
}

try {
    // Iniciar transacción
    $pdo->beginTransaction();

    // Verificar si tiene asistencias o incidencias asociadas
    $tiene_asistencias = query("SELECT COUNT(*) FROM asistencias WHERE id_estudiante = ?", [$id])->fetchColumn();
    $tiene_incidencias = query("SELECT COUNT(*) FROM incidencias WHERE id_estudiante = ?", [$id])->fetchColumn();

    if ($tiene_asistencias > 0 || $tiene_incidencias > 0) {
        // En lugar de eliminar, cambiar estado a 'retirado'
        query("UPDATE estudiantes SET estado = 'retirado' WHERE id = ?", [$id]);
        $mensaje = 'El estudiante tiene registros de asistencia o incidencias. Se ha cambiado su estado a "Retirado".';
    } else {
        // Eliminar usuario asociado si existe
        if ($estudiante['id_usuario']) {
            query("DELETE FROM usuarios WHERE id = ?", [$estudiante['id_usuario']]);
        }

        // Eliminar estudiante
        query("DELETE FROM estudiantes WHERE id = ?", [$id]);
        $mensaje = 'Estudiante eliminado correctamente';
    }

    // Confirmar transacción
    $pdo->commit();

    setAlerta('success', $mensaje);
    header('Location: index.php');
    exit;

} catch (Exception $e) {
    // Revertir transacción en caso de error
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    setAlerta('danger', 'Error al eliminar el estudiante: ' . $e->getMessage());
    header('Location: index.php');
    exit;
}
