# Sistema de Notificaciones de Ausencias - Instrucciones de Instalación

## Fecha: 2025-12-28

## Resumen de Cambios Implementados

Se ha implementado un sistema completo de notificaciones de ausencias automáticas con **REGISTRO AUTOMÁTICO DE FALTAS INJUSTIFICADAS**:

1. **Parámetros del Sistema**: Campo configurable para intervalo de notificación (minutos)
2. **Tabla de Notificaciones**: Registro de todas las notificaciones enviadas a apoderados
3. **Script Automatizado**: Detecta ausencias, REGISTRA FALTAS automáticamente y envía correos
4. **Escáner QR Optimizado**: 3 estados visuales (verde, naranja, rojo) para alta velocidad
5. **Registro Manual Mejorado**: Autocompletado de datos al escribir DNI

---

## Cambio Importante: Registro Automático de Faltas

El sistema ahora **REGISTRA AUTOMÁTICAMENTE** una **Falta Injustificada** a todos los estudiantes que:

1. No han registrado asistencia hoy
2. Han pasado los minutos configurados (ej: 90 minutos) desde su hora de ingreso
3. Tienen programación activa

**Después de registrar la falta:**
- Crea notificación en el sistema
- Envía correo electrónico al apoderado

---

## Archivos Creados/Modificados

### Archivos Nuevos:

| Archivo | Descripción |
|---------|-------------|
| [database/migracion_notificaciones.sql](../database/migracion_notificaciones.sql) | Script de migración para tabla de notificaciones |
| [tareas/verificar_ausencias.php](../tareas/verificar_ausencias.php) | Script automatizado de detección de ausencias con REGISTRO AUTOMÁTICO |
| [config/cron_verificar_ausencias.php](../config/cron_verificar_ausencias.php) | Punto de acceso HTTP para el cron job |

### Archivos Modificados:

| Archivo | Cambios |
|---------|---------|
| [config/parametros.php](../config/parametros.php) | Agregado campo "Intervalo Notificación Inasistencia (minutos)" |
| [config/ajax.php](../config/ajax.php) | Mejorado endpoint `buscar_estudiante` + nuevo endpoint `registrar_asistencia_manual` |
| [asistencias/escanear_qr.php](../asistencias/escanear_qr.php) | 3 estados optimizados para cola rápida |
| [asistencias/registrar_manual.php](../asistencias/registrar_manual.php) | Autocompletado + selector de estados |
| [composer.json](../composer.json) | Agregada dependencia PHPMailer |

---

## Pasos de Instalación

### 1. Ejecutar Migración de Base de Datos

```bash
# Windows (XAMPP)
cd c:\xampp\htdocs\SICA
mysql -u root -p sica2025 < database\migracion_notificaciones.sql

# Linux/Mac
mysql -u root -p sica2025 < database/migracion_notificaciones.sql
```

**Nota**: PHPMailer ya está instalado con `composer update`

### 2. Configurar Parámetros del Sistema

1. Ingresar a **Configuración → Parámetros**
2. Buscar la sección "Límites y Alertas"
3. Configurar el campo **"Intervalo Notificación Inasistencia (minutos)"**
   - Valor recomendado: **90 minutos** (1.5 horas después del horario de ingreso)
   - Mínimo: 1 minuto
   - Máximo: 480 minutos (8 horas)

4. Configurar SMTP si aún no está configurado:
   - Servidor SMTP (ej: smtp.gmail.com)
   - Puerto (587 para TLS)
   - Usuario (correo del sistema)
   - Contraseña (contraseña de aplicación)

### 3. Configurar Tarea Programada (CRON JOB)

El sistema está diseñado para ejecutarse cada **10 minutos** dentro del horario escolar.

#### Opción A: Windows Task Scheduler (Recomendado para XAMPP)

```cmd
schtasks /create /tn "SICA Verificar Ausencias" /tr "curl http://localhost/SICA/config/cron_verificar_ausencias.php" /sc minute /mo 10

# Para verificar que se creó:
schtasks /query /tn "SICA Verificar Ausencias"

# Para eliminar la tarea:
schtasks /delete /tn "SICA Verificar Ausencias" /f
```

#### Opción B: Linux Cron (Recomendado para servidores Linux)

```bash
# Editar crontab
crontab -e

# Agregar esta línea (ejecuta cada 10 minutos)
*/10 * * * * /usr/bin/curl -s http://localhost/SICA/config/cron_verificar_ausencias.php >> /var/log/sica_cron.log 2>&1
```

#### Opción C: Servicio Externo de Cron

Si tu servidor está en la nube y no tienes acceso a cron:

1. **cron-job.org** (gratis)
   - URL: `http://tu-dominio.com/SICA/config/cron_verificar_ausencias.php`
   - Ejecutar: Cada 10 minutos

2. **easycron.com**
   - Crear cron job con la misma URL
   - Frecuencia: 10 minutos

### 4. Probar el Script Manualmente

```bash
# Windows - Ejecutar directamente con PHP
cd c:\xampp\htdocs\SICA
php tareas\verificar_ausencias.php

# O a través del navegador
# http://localhost/SICA/config/cron_verificar_ausencias.php
```

**Resultado esperado:**
```
[2025-12-28 10:30:00] === INICIANDO VERIFICACIÓN DE AUSENCIAS ===
[2025-12-28 10:30:00] Intervalo de notificación: 90 minutos
[2025-12-28 10:30:00] Año lectivo activo: 2025-2026
[2025-12-28 10:30:00] Estudiantes sin asistencia: X
[2025-12-28 10:30:00] PROCESANDO: Pérez García, Juan (DNI: 12345678)
[2025-12-28 10:30:00]   - Hora ingreso: 07:00:00
[2025-12-28 10:30:00]   - Hora límite: 08:30:00
[2025-12-28 10:30:00]   - Hora actual: 10:30:00
[2025-12-28 10:30:00]   ✓ Falta injustificada registrada automáticamente
[2025-12-28 10:30:00]   ✓ Notificación creada (ID: 123)
[2025-12-28 10:30:00]   ✓ Correo enviado a: apoderado@email.com
...
[2025-12-28 10:30:00] === RESUMEN ===
[2025-12-28 10:30:00] Faltas injustificadas registradas: X
[2025-12-28 10:30:00] Notificaciones creadas: X
[2025-12-28 10:30:00] Correos enviados: X
[2025-12-28 10:30:00] === VERIFICACIÓN FINALIZADA ===
```

---

## Funcionamiento del Sistema

### 1. Flujo Automático Cada 10 Minutos

```
┌─────────────────────────────────────────────────────────────┐
│ 1. Script se ejecuta (cada 10 min)                          │
└──────────────────┬──────────────────────────────────────────┘
                   │
                   ▼
┌─────────────────────────────────────────────────────────────┐
│ 2. Obtiene parámetro: intervalo_notificacion_inasistencia  │
│    Ejemplo: 90 minutos                                     │
└──────────────────┬──────────────────────────────────────────┘
                   │
                   ▼
┌─────────────────────────────────────────────────────────────┐
│ 3. Busca estudiantes sin asistencia hoy                     │
│    - Con programación activa                                │
│    - Con apoderado asignado                                 │
└──────────────────┬──────────────────────────────────────────┘
                   │
                   ▼
┌─────────────────────────────────────────────────────────────┐
│ 4. Para cada estudiante:                                    │
│    - Calcula: hora_ingreso + 90 minutos                    │
│    - Si hora_actual >= hora_limite:                        │
│      ✓ Registrar FALTA INJUSTIFICADA                       │
│      ✓ Crear notificación en BD                           │
│      ✓ Enviar correo al apoderado                          │
└─────────────────────────────────────────────────────────────┘
```

### 2. Registro Automático de Faltas

**Cada estudiante recibe:**
- **Estado**: "Falta Injustificada" (de `estados_asistencia`)
- **Fecha**: Fecha actual
- **Hora**: Hora en que se ejecuta el script
- **Registrado por**: "SISTEMA"
- **Método**: "automatico"

### 3. Correo Enviado al Apoderado

```
Asunto: Ausencia Registrada - Pérez, Juan

Estimado(a) López Rodríguez:

Se le informa que su estudiante Juan Pérez García
NO ha registrado asistencia hoy 28/12/2025.

Se ha registrado automáticamente una FALTA INJUSTIFICADA en el sistema.

Datos del estudiante:
• DNI: 12345678
• Nivel: Secundaria
• Grado: 1°
• Sección: "A"
• Turno: 07:00 - 12:00
• Hora de registro automático: 10:30

Fecha de notificación: 28/12/2025 10:30

Si esta falta es un error o puede justificarse, por favor contacte a la institución.
```

### 4. Escáner QR - 3 Estados Optimizados

**Estado VERDE (Éxito):**
- Color: Gradiente verde
- Icono: ✓ Registrado
- Mensaje: Nombre + DNI
- Sonido: Beep agudo (800Hz)
- Pausa: **1 segundo** (para cola rápida)

**Estado NARANJA (Duplicado):**
- Color: Gradiente naranja
- Icono: ⚠ Duplicado
- Mensaje: "Ya registró asistencia"
- Sonido: Beep medio (400Hz)
- Pausa: **1.5 segundos**

**Estado ROJO (Error):**
- Color: Gradiente rojo
- Icono: ✖ Error
- Mensaje: Breve descripción
- Sonido: Beep grave (200Hz)
- Pausa: **1.5 - 2 segundos**

### 5. Registro Manual con Autocompletado

**Flujo:**
1. Usuario escribe 8 dígitos del DNI
2. Sistema busca automáticamente al estudiante
3. Muestra tarjeta azul con información completa
4. Usuario selecciona:
   - **Estado**: Asistencia, Tardanza, Falta Justificada, etc.
   - **Hora**: Cualquier hora (editable)
   - **Observaciones**: Opcional
5. Al registrar, muestra confirmación verde

---

## Verificación de Logs

El script genera logs en:

```
SICA/tareas/logs/verificar_ausencias.log
```

**Contenido del log:**
```
[2025-12-28 10:30:00] === INICIANDO VERIFICACIÓN DE AUSENCIAS ===
[2025-12-28 10:30:00] Intervalo de notificación: 90 minutos
[2025-12-28 10:30:00] Año lectivo activo: 2025-2026
[2025-12-28 10:30:00] Estudiantes sin asistencia: 15
[2025-12-28 10:30:00] PROCESANDO: Pérez García, Juan (DNI: 12345678)
[2025-12-28 10:30:00]   - Hora ingreso: 07:00:00
[2025-12-28 10:30:00]   - Hora límite: 08:30:00
[2025-12-28 10:30:00]   - Hora actual: 10:30:00
[2025-12-28 10:30:00]   ✓ Falta injustificada registrada automáticamente
[2025-12-28 10:30:00]   ✓ Notificación creada (ID: 123)
[2025-12-28 10:30:00]   ✓ Correo enviado a: apoderado@email.com
...
[2025-12-28 10:30:00] === RESUMEN ===
[2025-12-28 10:30:00] Faltas injustificadas registradas: 10
[2025-12-28 10:30:00] Notificaciones creadas: 10
[2025-12-28 10:30:00] Correos enviados: 8
[2025-12-28 10:30:00] === VERIFICACIÓN FINALIZADA ===
```

---

## Ejemplo de Ejecución

### Escenario: Institución con 3 Turnos

**Configuración:**
- Intervalo de notificación: **90 minutos**
- Hora actual: **10:30 AM**

**Turno Mañana (07:00 - 12:00):**
- Hora ingreso: 07:00
- Hora límite: 08:30 (07:00 + 90 min)
- **Todos los estudiantes sin asistencia tienen FALTA REGISTRADA**

**Turno Tarde (13:00 - 18:00):**
- Hora ingreso: 13:00
- Hora límite: 14:30 (13:00 + 90 min)
- **Aún NO se registra falta (falta 1 hora para el límite)**

---

## Prevención de Duplicados

El sistema tiene **3 niveles de protección**:

1. **Antes de procesar**: Verifica si ya existe asistencia
2. **Antes de registrar**: Doble verificación de asistencia
3. **Antes de notificar**: Verifica si ya existe notificación hoy

**Resultado**: Un estudiante solo puede recibir:
- **Máximo 1 falta por día**
- **Máximo 1 notificación por día**
- **Máximo 1 correo por día**

---

## Solución de Problemas

### El script no ejecuta (error 500)

**Posibles causas:**
1. PHPMailer no instalado → Ejecutar `composer update`
2. Permisos de escritura en `tareas/logs/` → Dar permisos 755
3. Error de conexión a BD → Verificar `config/db.php`

### No se registran las faltas

**Verificar:**
1. Que exista el estado "Falta Injustificada" en `estados_asistencia`
2. Que el intervalo de notificación esté configurado en parámetros
3. Que la hora actual sea mayor a la hora límite del estudiante
4. Logs del script para ver errores específicos

### Los correos no se envían

**Verificar:**
1. Configuración SMTP en Parámetros
2. Que el apoderado tenga email registrado
3. Logs para ver mensajes de error de PHPMailer
4. Puerto SMTP (587 para TLS, 465 para SSL)

### Demasiados correos enviados

**El script ya previene esto:**
- Solo envía 1 correo por estudiante por día
- Verifica si ya existe notificación antes de enviar
- No procesa estudiantes que ya tienen asistencia

---

## Estructura de Tablas

### Tabla `notificaciones`

```sql
CREATE TABLE notificaciones (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_apoderado INT NOT NULL,
    id_estudiante INT NOT NULL,
    tipo ENUM('inasistencia', 'tardanza', 'falta_repetida', 'alerta'),
    titulo VARCHAR(200) NOT NULL,
    mensaje TEXT NOT NULL,
    fecha_notificacion DATETIME DEFAULT CURRENT_TIMESTAMP,
    leida BOOLEAN DEFAULT FALSE,
    fecha_lectura DATETIME NULL,
    email_enviado BOOLEAN DEFAULT FALSE,
    fecha_email DATETIME NULL,
    id_anio_lectivo INT NOT NULL,
    estado ENUM('activo', 'archivado') DEFAULT 'activo',
    FOREIGN KEY (id_apoderado) REFERENCES apoderados(id),
    FOREIGN KEY (id_estudiante) REFERENCES estudiantes(id),
    FOREIGN KEY (id_anio_lectivo) REFERENCES anios_lectivos(id)
);
```

### Tabla `asistencias` (Registro automático)

```sql
INSERT INTO asistencias (
    id_estudiante,
    id_anio_lectivo,
    id_programacion,
    id_turno,
    id_estado_asistencia,  -- ID de "Falta Injustificada"
    fecha,
    hora_registro,
    estado_codigo,         -- "Falta Injustificada"
    minutos_tardanza,      -- 0
    registrado_por,        -- "SISTEMA"
    metodo_registro        -- "automatico"
)
```

---

## Próximos Pasos (Opcionales)

### Portal del Apoderado

Crear un módulo donde los apoderados puedan:
- Ver sus notificaciones
- Marcar como leídas
- Justificar faltas online

### Reportes

Crear reportes de:
- Estudiantes con más faltas injustificadas
- Apoderados que no reciben correos (email inválido)
- Estadísticas mensuales de notificaciones
- Comparativa de faltas por mes/sección

### Alertas de Tendencia

Detectar automáticamente:
- Estudiantes con 3+ faltas en la semana
- Estudiantes con faltas consecutivas
- Secciones con alto índice de ausencias

---

## Mantenimiento

### Verificar Ejecución del Cron

```bash
# Windows
schtasks /query /tn "SICA Verificar Ausencias" /fo LIST

# Linux
grep CRON /var/log/syslog | tail -20
```

### Limpiar Logs Antiguos

```bash
# Eliminar logs de más de 30 días
find c:\xampp\htdocs\SICA\tareas\logs\ -name "*.log" -mtime +30 -delete
```

### Verificar Espacio en BD

```sql
-- Contar notificaciones
SELECT COUNT(*) as total FROM notificaciones;

-- Contar por año lectivo
SELECT id_anio_lectivo, COUNT(*) as total
FROM notificaciones
GROUP BY id_anio_lectivo;

-- Limpiar notificaciones antiguas (más de 1 año)
DELETE FROM notificaciones
WHERE fecha_notificacion < DATE_SUB(NOW(), INTERVAL 1 YEAR);
```

---

## Archivo de Registro de Cambios

Actualizar [CLAUDE.md](../CLAUDE.md) con:

```markdown
## 2025-12-28 - Sistema de Notificaciones de Ausencias (v2.0)

**Descripción General:**
Implementación completa de sistema de notificaciones automáticas con REGISTRO AUTOMÁTICO DE FALTAS INJUSTIFICADAS.

**Características:**
- Registro automático de faltas injustificadas después de X minutos del horario
- Envío de correos a apoderados
- Notificaciones en el sistema
- Escáner QR optimizado con 3 estados
- Registro manual con autocompletado

**Archivos:**
- tareas/verificar_ausencias.php (REGISTRA FALTAS automáticamente)
- config/cron_verificar_ausencias.php (endpoint HTTP para cron)
- database/migracion_notificaciones.sql (tabla de notificaciones)
```
