<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$id = intval($_GET['id'] ?? 0);

if (!$id) {
    header('Location: index.php');
    exit;
}

// Obtener docente
$docente = query("SELECT d.*, u.usuario, u.ultimo_acceso, u.fecha_registro as fecha_registro_usuario
                 FROM docentes d
                 LEFT JOIN usuarios u ON d.id_usuario = u.id
                 WHERE d.id = :id", ['id' => $id])->fetch();

if (!$docente) {
    header('Location: index.php');
    exit;
}

// Obtener año lectivo seleccionado
$anio_seleccionado = getAnioLectivoSeleccionado();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Ver Docente</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="d-flex align-items-center">
            <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                <i class="bi bi-list fs-4"></i>
            </button>
            <div>
                <h3 class="mb-1">Detalle del Docente</h3>
                <p class="text-muted mb-0">Información completa del docente</p>
            </div>
        </div>
        <a href="index.php" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Volver
        </a>
    </div>

        <div class="row">
            <!-- Información Personal -->
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-person-badge"></i> Información Personal</h5>
                    </div>
                    <div class="card-body">
                        <div class="text-center mb-4">
                            <div class="avatar-circle avatar-lg mb-2">
                                <?= substr($docente['nombres'], 0, 1) . substr($docente['apellido_paterno'], 0, 1) ?>
                            </div>
                            <h4><?= htmlspecialchars($docente['apellido_paterno'] . ' ' . $docente['apellido_materno'] . ', ' . $docente['nombres']) ?></h4>
                            <p class="text-muted mb-0">@<?= htmlspecialchars($docente['usuario']) ?></p>
                        </div>

                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>DNI:</strong></td>
                                <td><?= htmlspecialchars($docente['dni']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Apellido Paterno:</strong></td>
                                <td><?= htmlspecialchars($docente['apellido_paterno']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Apellido Materno:</strong></td>
                                <td><?= htmlspecialchars($docente['apellido_materno']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Nombres:</strong></td>
                                <td><?= htmlspecialchars($docente['nombres']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Género:</strong></td>
                                <td><?= $docente['genero'] === 'M' ? 'Masculino' : 'Femenino' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Fecha Nacimiento:</strong></td>
                                <td><?= $docente['fecha_nacimiento'] ? date('d/m/Y', strtotime($docente['fecha_nacimiento'])) : '-' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Email:</strong></td>
                                <td><?= htmlspecialchars($docente['email'] ?: '-') ?></td>
                            </tr>
                            <tr>
                                <td><strong>Teléfono:</strong></td>
                                <td><?= htmlspecialchars($docente['telefono'] ?: '-') ?></td>
                            </tr>
                            <tr>
                                <td><strong>Dirección:</strong></td>
                                <td><?= htmlspecialchars($docente['direccion'] ?: '-') ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Información del Sistema -->
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="bi bi-info-circle"></i> Información del Sistema</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>Usuario:</strong></td>
                                <td>
                                    <code><?= htmlspecialchars($docente['usuario']) ?></code>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Rol:</strong></td>
                                <td><span class="badge bg-info">Docente</span></td>
                            </tr>
                            <tr>
                                <td><strong>Estado Docente:</strong></td>
                                <td>
                                    <?php
                                    $badge_class = match($docente['estado']) {
                                        'activo' => 'bg-success',
                                        'inactivo' => 'bg-secondary',
                                        'retirado' => 'bg-warning',
                                        default => 'bg-secondary'
                                    };
                                    ?>
                                    <span class="badge <?= $badge_class ?>">
                                        <?= ucfirst($docente['estado']) ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Fecha Registro:</strong></td>
                                <td><?= date('d/m/Y H:i', strtotime($docente['fecha_registro_usuario'])) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Último Acceso:</strong></td>
                                <td>
                                    <?php if ($docente['ultimo_acceso']): ?>
                                        <?= date('d/m/Y H:i', strtotime($docente['ultimo_acceso'])) ?>
                                    <?php else: ?>
                                        <span class="text-muted">Sin accesos</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>

                        <hr>

                        <div class="d-grid gap-2">
                            <a href="editar.php?id=<?= $docente['id'] ?>" class="btn btn-primary">
                                <i class="bi bi-pencil"></i> Editar Información
                            </a>
                            <a href="../perfil.php" class="btn btn-outline-primary">
                                <i class="bi bi-key"></i> Cambiar Contraseña
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Acciones -->
        <div class="card">
            <div class="card-body">
                <div class="d-flex gap-2">
                    <a href="editar.php?id=<?= $docente['id'] ?>" class="btn btn-primary">
                        <i class="bi bi-pencil"></i> Editar
                    </a>
                    <a href="index.php" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Volver al Listado
                    </a>
                    <a href="eliminar.php?id=<?= $docente['id'] ?>" class="btn btn-outline-danger ms-auto"
                        onclick="return confirm('¿Está seguro de eliminar este docente?')">
                        <i class="bi bi-trash"></i> Eliminar
                    </a>
                </div>
            </div>
        </div>
    </div>

    <?php include '../includes/layout_scripts.php'; ?>
</body>
</html>
