<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$mensaje = '';
$tipo_mensaje = '';

// Obtener filtros
$filtro_estado = $_GET['estado'] ?? '';
$filtro_busqueda = $_GET['busqueda'] ?? '';

// Obtener año lectivo seleccionado
$anio_seleccionado = getAnioLectivoSeleccionado();

// Construir consulta
$sql = "SELECT d.*, u.usuario, u.ultimo_acceso
        FROM docentes d
        LEFT JOIN usuarios u ON d.id_usuario = u.id
        WHERE 1=1";
$params = [];

if (!empty($filtro_estado)) {
    $sql .= " AND d.estado = :estado";
    $params['estado'] = $filtro_estado;
}

if (!empty($filtro_busqueda)) {
    $sql .= " AND (d.dni LIKE :busqueda1
               OR d.apellido_paterno LIKE :busqueda2
               OR d.apellido_materno LIKE :busqueda3
               OR d.nombres LIKE :busqueda4
               OR CONCAT(d.apellido_paterno, ' ', d.apellido_materno, ' ', d.nombres) LIKE :busqueda5)";
    $busqueda_param = "%$filtro_busqueda%";
    $params['busqueda1'] = $busqueda_param;
    $params['busqueda2'] = $busqueda_param;
    $params['busqueda3'] = $busqueda_param;
    $params['busqueda4'] = $busqueda_param;
    $params['busqueda5'] = $busqueda_param;
}

$sql .= " ORDER BY d.apellido_paterno, d.apellido_materno, d.nombres";

$docentes = query($sql, $params)->fetchAll();

// Estadísticas (SOLO docentes con usuario válido)
$stats = [
    'total' => query("SELECT COUNT(*) as c FROM docentes d INNER JOIN usuarios u ON d.id_usuario = u.id")->fetch()['c'],
    'activos' => query("SELECT COUNT(*) as c FROM docentes d INNER JOIN usuarios u ON d.id_usuario = u.id WHERE d.estado = 'activo'")->fetch()['c'],
    'inactivos' => query("SELECT COUNT(*) as c FROM docentes d INNER JOIN usuarios u ON d.id_usuario = u.id WHERE d.estado = 'inactivo'")->fetch()['c'],
    'retirados' => query("SELECT COUNT(*) as c FROM docentes d INNER JOIN usuarios u ON d.id_usuario = u.id WHERE d.estado = 'retirado'")->fetch()['c']
];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Docentes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <!-- Botón hamburguesa para móvil -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="d-flex align-items-center">
            <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                <i class="bi bi-list fs-4"></i>
            </button>
            <div>
                <h3 class="mb-1">Gestión de Docentes</h3>
                <p class="text-muted mb-0">Administre la información de los docentes del sistema</p>
            </div>
        </div>
        <div>
            <a href="importar.php" class="btn btn-success me-2">
                <i class="bi bi-file-earmark-excel"></i> Importar Excel
            </a>
            <a href="crear.php" class="btn btn-primary">
                <i class="bi bi-person-plus"></i> Nuevo Docente
            </a>
        </div>
    </div>

    <?php if ($mensaje): ?>
            <div class="alert alert-<?= $tipo_mensaje ?> alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($mensaje) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Estadísticas -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card stats-card border-0">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="stats-icon bg-primary">
                                <i class="bi bi-people-fill"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-muted">Total</h6>
                                <h3 class="mb-0"><?= $stats['total'] ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stats-card border-0">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="stats-icon bg-success">
                                <i class="bi bi-check-circle-fill"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-muted">Activos</h6>
                                <h3 class="mb-0"><?= $stats['activos'] ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stats-card border-0">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="stats-icon bg-secondary">
                                <i class="bi bi-dash-circle-fill"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-muted">Inactivos</h6>
                                <h3 class="mb-0"><?= $stats['inactivos'] ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stats-card border-0">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="stats-icon bg-warning">
                                <i class="bi bi-person-x-fill"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-muted">Retirados</h6>
                                <h3 class="mb-0"><?= $stats['retirados'] ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filtros -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label fw-bold"><i class="bi bi-search"></i> Buscar</label>
                        <input type="text" name="busqueda" class="form-control"
                            placeholder="DNI, nombres o apellidos"
                            value="<?= htmlspecialchars($filtro_busqueda) ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold"><i class="bi bi-funnel"></i> Estado</label>
                        <select name="estado" class="form-select">
                            <option value="">Todos</option>
                            <option value="activo" <?= $filtro_estado === 'activo' ? 'selected' : '' ?>>Activo</option>
                            <option value="inactivo" <?= $filtro_estado === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
                            <option value="retirado" <?= $filtro_estado === 'retirado' ? 'selected' : '' ?>>Retirado</option>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="bi bi-filter"></i> Filtrar
                        </button>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <a href="index.php" class="btn btn-outline-secondary w-100">
                            <i class="bi bi-x-circle"></i> Limpiar
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Tabla -->
        <div class="card">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-list-ul"></i> Listado de Docentes (<?= count($docentes) ?>)</h5>
            </div>
            <div class="card-body p-0">
                <?php if (empty($docentes)): ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox text-muted" style="font-size: 3rem;"></i>
                        <p class="text-muted mt-3">No hay docentes registrados</p>
                        <a href="crear.php" class="btn btn-primary">
                            <i class="bi bi-plus-circle"></i> Registrar Primer Docente
                        </a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>DNI</th>
                                    <th>Docente</th>
                                    <th>Email</th>
                                    <th>Teléfono</th>
                                    <th>Estado</th>
                                    <th>Último Acceso</th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($docentes as $doc): ?>
                                    <?php
                                    $nombre_completo = htmlspecialchars($doc['apellido_paterno'] . ' ' . $doc['apellido_materno'] . ', ' . $doc['nombres']);
                                    $badge_class = match($doc['estado']) {
                                        'activo' => 'bg-success',
                                        'inactivo' => 'bg-secondary',
                                        'retirado' => 'bg-warning',
                                        default => 'bg-secondary'
                                    };
                                    ?>
                                    <tr>
                                        <td><span class="fw-bold"><?= htmlspecialchars($doc['dni']) ?></span></td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-circle avatar-sm me-2">
                                                    <?= substr($doc['nombres'], 0, 1) . substr($doc['apellido_paterno'], 0, 1) ?>
                                                </div>
                                                <div>
                                                    <div class="fw-bold"><?= $nombre_completo ?></div>
                                                    <small class="text-muted">@<?= htmlspecialchars($doc['usuario']) ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?= htmlspecialchars($doc['email'] ?: '-') ?></td>
                                        <td><?= htmlspecialchars($doc['telefono'] ?: '-') ?></td>
                                        <td>
                                            <span class="badge <?= $badge_class ?>">
                                                <?= ucfirst($doc['estado']) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if ($doc['ultimo_acceso']): ?>
                                                <small class="text-muted">
                                                    <i class="bi bi-clock"></i>
                                                    <?= date('d/m/Y H:i', strtotime($doc['ultimo_acceso'])) ?>
                                                </small>
                                            <?php else: ?>
                                                <small class="text-muted">Sin acceso</small>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group" role="group">
                                                <a href="ver.php?id=<?= $doc['id'] ?>"
                                                    class="btn btn-sm btn-outline-info"
                                                    title="Ver detalles">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                                <a href="editar.php?id=<?= $doc['id'] ?>"
                                                    class="btn btn-sm btn-outline-primary"
                                                    title="Editar">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <a href="eliminar.php?id=<?= $doc['id'] ?>"
                                                    class="btn btn-sm btn-outline-danger"
                                                    title="Eliminar"
                                                    onclick="return confirm('¿Está seguro de eliminar este docente?')">
                                                    <i class="bi bi-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php include '../includes/layout_scripts.php'; ?>
</body>
</html>
