<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$mensaje = '';
$tipo_mensaje = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dni = trim($_POST['dni'] ?? '');
    $apellido_paterno = trim($_POST['apellido_paterno'] ?? '');
    $apellido_materno = trim($_POST['apellido_materno'] ?? '');
    $nombres = trim($_POST['nombres'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $telefono = trim($_POST['telefono'] ?? '');
    $direccion = trim($_POST['direccion'] ?? '');
    $fecha_nacimiento = $_POST['fecha_nacimiento'] ?? null;
    $genero = $_POST['genero'] ?? null;

    // Validaciones
    if (empty($dni) || empty($apellido_paterno) || empty($apellido_materno) || empty($nombres)) {
        $mensaje = 'DNI, apellidos y nombres son obligatorios';
        $tipo_mensaje = 'danger';
    } elseif (!preg_match('/^\d{8}$/', $dni)) {
        $mensaje = 'El DNI debe tener exactamente 8 dígitos';
        $tipo_mensaje = 'danger';
    } elseif (empty($email)) {
        $mensaje = 'El email es obligatorio';
        $tipo_mensaje = 'danger';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $mensaje = 'El email no es válido';
        $tipo_mensaje = 'danger';
    } elseif (empty($telefono)) {
        $mensaje = 'El teléfono es obligatorio';
        $tipo_mensaje = 'danger';
    } else {
        try {
            // Iniciar transacción
            $pdo->beginTransaction();

            // Verificar si ya existe el DNI
            $check_dni = query("SELECT COUNT(*) as c FROM docentes WHERE dni = :dni", ['dni' => $dni])->fetch();
            if ($check_dni['c'] > 0) {
                throw new Exception('Ya existe un docente con este DNI');
            }

            // Crear usuario
            $password = password_hash($dni, PASSWORD_DEFAULT); // DNI como contraseña por defecto
            $usuario = $dni; // DNI como nombre de usuario

            $sql_usuario = "INSERT INTO usuarios (usuario, password, rol, estado) VALUES (:usuario, :password, 'docente', 'activo')";
            $stmt_usuario = $pdo->prepare($sql_usuario);
            $stmt_usuario->execute([
                'usuario' => $usuario,
                'password' => $password
            ]);
            $id_usuario = $pdo->lastInsertId();

            // Crear docente
            $sql_docente = "INSERT INTO docentes (id_usuario, dni, apellido_paterno, apellido_materno, nombres, email, telefono, direccion, fecha_nacimiento, genero)
                           VALUES (:id_usuario, :dni, :apellido_paterno, :apellido_materno, :nombres, :email, :telefono, :direccion, :fecha_nacimiento, :genero)";
            $stmt_docente = $pdo->prepare($sql_docente);
            $stmt_docente->execute([
                'id_usuario' => $id_usuario,
                'dni' => $dni,
                'apellido_paterno' => $apellido_paterno,
                'apellido_materno' => $apellido_materno,
                'nombres' => $nombres,
                'email' => $email,
                'telefono' => $telefono,
                'direccion' => $direccion ?: null,
                'fecha_nacimiento' => $fecha_nacimiento ?: null,
                'genero' => $genero ?: null
            ]);

            $pdo->commit();
            $mensaje = 'Docente registrado exitosamente. Usuario: ' . $dni . ', Contraseña: ' . $dni;
            $tipo_mensaje = 'success';

            // Limpiar formulario
            $_POST = [];
        } catch (Exception $e) {
            $pdo->rollBack();
            $mensaje = 'Error al registrar: ' . $e->getMessage();
            $tipo_mensaje = 'danger';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Nuevo Docente</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <nav class="sidebar">
        <?php include '../includes/sidebar.php'; ?>
    </nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="mb-1">Nuevo Docente</h3>
                <p class="text-muted mb-0">Registrar un nuevo docente en el sistema</p>
            </div>
            <a href="index.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Volver
            </a>
        </div>

        <?php if ($mensaje): ?>
            <div class="alert alert-<?= $tipo_mensaje ?> alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($mensaje) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-person-plus"></i> Datos del Docente</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="dni" class="form-label">DNI <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="dni" name="dni"
                                            value="<?= htmlspecialchars($_POST['dni'] ?? '') ?>"
                                            pattern="\d{8}" maxlength="8" required
                                            placeholder="8 dígitos">
                                        <div class="form-text">Se usará como usuario y contraseña</div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="apellido_paterno" class="form-label">Apellido Paterno <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="apellido_paterno" name="apellido_paterno"
                                            value="<?= htmlspecialchars($_POST['apellido_paterno'] ?? '') ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="apellido_materno" class="form-label">Apellido Materno <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="apellido_materno" name="apellido_materno"
                                            value="<?= htmlspecialchars($_POST['apellido_materno'] ?? '') ?>" required>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="nombres" class="form-label">Nombres <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="nombres" name="nombres"
                                    value="<?= htmlspecialchars($_POST['nombres'] ?? '') ?>" required>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                        <input type="email" class="form-control" id="email" name="email" required
                                            value="<?= htmlspecialchars($_POST['email'] ?? '') ?>"
                                            placeholder="correo@ejemplo.com">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="telefono" class="form-label">Teléfono <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="telefono" name="telefono" required
                                            value="<?= htmlspecialchars($_POST['telefono'] ?? '') ?>"
                                            placeholder="999 999 999">
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="direccion" class="form-label">Dirección</label>
                                <textarea class="form-control" id="direccion" name="direccion" rows="2"><?= htmlspecialchars($_POST['direccion'] ?? '') ?></textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="fecha_nacimiento" class="form-label">Fecha de Nacimiento</label>
                                        <input type="date" class="form-control" id="fecha_nacimiento" name="fecha_nacimiento"
                                            value="<?= htmlspecialchars($_POST['fecha_nacimiento'] ?? '') ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Género</label>
                                        <div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="genero" id="genero_m" value="M"
                                                    <?= (isset($_POST['genero']) && $_POST['genero'] === 'M') ? 'checked' : '' ?>>
                                                <label class="form-check-label" for="genero_m">Masculino</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="genero" id="genero_f" value="F"
                                                    <?= (isset($_POST['genero']) && $_POST['genero'] === 'F') ? 'checked' : '' ?>>
                                                <label class="form-check-label" for="genero_f">Femenino</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr>

                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary flex-grow-1">
                                    <i class="bi bi-save"></i> Guardar Docente
                                </button>
                                <a href="index.php" class="btn btn-secondary">
                                    <i class="bi bi-x-circle"></i> Cancelar
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card mb-3">
                    <div class="card-body">
                        <h6 class="card-title"><i class="bi bi-info-circle text-primary"></i> Información</h6>
                        <p class="small text-muted mb-0">
                            Al crear un nuevo docente, se generará automáticamente:
                        </p>
                        <ul class="small text-muted">
                            <li><strong>Usuario:</strong> El número de DNI</li>
                            <li><strong>Contraseña:</strong> El número de DNI (puede cambiarla luego)</li>
                            <li><strong>Rol:</strong> Docente</li>
                        </ul>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title"><i class="bi bi-lightbulb text-warning"></i> Recomendaciones</h6>
                        <ul class="small text-muted mb-0">
                            <li>El DNI debe tener 8 dígitos</li>
                            <li>El email es opcional pero recomendado</li>
                            <li>Los campos con * son obligatorios</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
