<?php
require_once 'config/db.php';

echo "<pre>";
echo "=== DIAGNÓSTICO DE PERSONAL (DOCENTES Y AUXILIARES) ===\n\n";

// Verificar DOCENTES
echo "1. DOCENTES:\n";
echo str_repeat("-", 50) . "\n";

try {
    // Total de docentes
    $total = query("SELECT COUNT(*) as total FROM docentes")->fetch()['total'];
    echo "Total docentes en BD: $total\n";

    // Por estado
    $activos = query("SELECT COUNT(*) as total FROM docentes WHERE estado = 'activo'")->fetch()['total'];
    $inactivos = query("SELECT COUNT(*) as total FROM docentes WHERE estado = 'inactivo'")->fetch()['total'];
    $retirados = query("SELECT COUNT(*) as total FROM docentes WHERE estado = 'retirado'")->fetch()['total'];

    echo "  - Activos: $activos\n";
    echo "  - Inactivos: $inactivos\n";
    echo "  - Retirados: $retirados\n";
    echo "  - Total (suma): " . ($activos + $inactivos + $retirados) . "\n\n";

    // Listar todos los docentes
    echo "Lista de docentes:\n";
    $docentes = query("SELECT d.id, d.dni, CONCAT(d.apellido_paterno, ' ', d.nombres) as nombre, d.estado, u.usuario, u.estado as estado_usuario
                       FROM docentes d
                       INNER JOIN usuarios u ON d.id_usuario = u.id")->fetchAll();

    if (empty($docentes)) {
        echo "  ⚠ NO HAY DOCENTES REGISTRADOS\n";
    } else {
        foreach ($docentes as $d) {
            echo sprintf("  ID: %d | DNI: %s | %s | Docente: %s | Usuario: %s\n",
                $d['id'], $d['dni'], $d['nombre'], $d['estado'], $d['estado_usuario']);
        }
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n";

// Verificar AUXILIARES
echo "2. AUXILIARES:\n";
echo str_repeat("-", 50) . "\n";

try {
    // Total de auxiliares
    $total = query("SELECT COUNT(*) as total FROM auxiliares")->fetch()['total'];
    echo "Total auxiliares en BD: $total\n";

    // Por estado
    $activos = query("SELECT COUNT(*) as total FROM auxiliares WHERE estado = 'activo'")->fetch()['total'];
    $inactivos = query("SELECT COUNT(*) as total FROM auxiliares WHERE estado = 'inactivo'")->fetch()['total'];
    $retirados = query("SELECT COUNT(*) as total FROM auxiliares WHERE estado = 'retirado'")->fetch()['total'];

    echo "  - Activos: $activos\n";
    echo "  - Inactivos: $inactivos\n";
    echo "  - Retirados: $retirados\n";
    echo "  - Total (suma): " . ($activos + $inactivos + $retirados) . "\n\n";

    // Listar todos los auxiliares
    echo "Lista de auxiliares:\n";
    $auxiliares = query("SELECT a.id, a.dni, CONCAT(a.apellido_paterno, ' ', a.nombres) as nombre, a.estado, u.usuario, u.estado as estado_usuario
                        FROM auxiliares a
                        INNER JOIN usuarios u ON a.id_usuario = u.id")->fetchAll();

    if (empty($auxiliares)) {
        echo "  ⚠ NO HAY AUXILIARES REGISTRADOS\n";
    } else {
        foreach ($auxiliares as $a) {
            echo sprintf("  ID: %d | DNI: %s | %s | Auxiliar: %s | Usuario: %s\n",
                $a['id'], $a['dni'], $a['nombre'], $a['estado'], $a['estado_usuario']);
        }
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n=== FIN DEL DIAGNÓSTICO ===\n";
echo "</pre>";

echo "<hr>";
echo "<p><a href='docentes/index.php' class='btn btn-primary'>Ir a Docentes</a> ";
echo "<a href='auxiliares/index.php' class='btn btn-primary'>Ir a Auxiliares</a></p>";
?>
