<?php
require_once 'config/db.php';

echo "<pre>";
echo "=== DIAGNÓSTICO DE APODERADOS Y ESTUDIANTES ===\n\n";

// 1. Verificar apoderados huérfanos
echo "1. APODERADOS:\n";
echo str_repeat("-", 50) . "\n";

try {
    // Total de apoderados
    $total = query("SELECT COUNT(*) as total FROM apoderados")->fetch()['total'];
    echo "Total apoderados en BD: $total\n";

    // Por estado
    $activos = query("SELECT COUNT(*) as total FROM apoderados WHERE estado = 'activo'")->fetch()['total'];
    $inactivos = query("SELECT COUNT(*) as total FROM apoderados WHERE estado = 'inactivo'")->fetch()['total'];
    $retirados = query("SELECT COUNT(*) as total FROM apoderados WHERE estado = 'retirado'")->fetch()['total'];

    echo "  - Activos: $activos\n";
    echo "  - Inactivos: $inactivos\n";
    echo "  - Retirados: $retirados\n";
    echo "  - Total (suma): " . ($activos + $inactivos + $retirados) . "\n\n";

    // Apoderados con usuario
    $con_usuario = query("SELECT COUNT(*) as total FROM apoderados a INNER JOIN usuarios u ON a.id_usuario = u.id")->fetch()['total'];
    echo "Apoderados con usuario: $con_usuario\n\n";

    // Listar todos los apoderados
    echo "Lista de apoderados:\n";
    $apoderados = query("SELECT a.id, a.dni, CONCAT(a.apellido_paterno, ' ', a.nombres) as nombre, a.estado, u.usuario, u.estado as estado_usuario
                        FROM apoderados a
                        INNER JOIN usuarios u ON a.id_usuario = u.id")->fetchAll();

    if (empty($apoderados)) {
        echo "  ⚠ NO HAY APODERADOS REGISTRADOS\n";
    } else {
        foreach ($apoderados as $a) {
            echo sprintf("  ID: %d | DNI: %s | %s | Estado: %s | Usuario: %s\n",
                $a['id'], $a['dni'], $a['nombre'], $a['estado'], $a['estado_usuario']);
        }
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n";

// 2. Verificar estudiantes y sus apoderados
echo "2. ESTUDIANTES Y SUS APODERADOS:\n";
echo str_repeat("-", 50) . "\n";

try {
    // Total de estudiantes
    $total_est = query("SELECT COUNT(*) as total FROM estudiantes")->fetch()['total'];
    echo "Total estudiantes en BD: $total_est\n\n";

    // Estudiantes con usuario
    $con_usuario = query("SELECT COUNT(*) as total FROM estudiantes e INNER JOIN usuarios u ON e.id_usuario = u.id")->fetch()['total'];
    echo "Estudiantes con usuario: $con_usuario\n\n";

    // Estudiantes con apoderado asignado
    $con_apoderado = query("SELECT COUNT(*) as total FROM estudiantes_apoderados WHERE estado = 'activo'")->fetch()['total'];
    echo "Estudiantes con apoderado activo: $con_apoderado\n\n";

    // Estudiantes SIN apoderado
    $sin_apoderado = query("
        SELECT e.id, e.dni, CONCAT(e.apellido_paterno, ' ', e.nombres) as nombre
        FROM estudiantes e
        WHERE e.estado = 'activo'
        AND NOT EXISTS (
            SELECT 1 FROM estudiantes_apoderados ea
            WHERE ea.id_estudiante = e.id AND ea.estado = 'activo'
        )
    ")->fetchAll();

    echo "Estudiantes ACTIVOS sin apoderado:\n";
    if (empty($sin_apoderado)) {
        echo "  ✓ Todos los estudiantes tienen apoderado\n";
    } else {
        foreach ($sin_apoderado as $e) {
            echo sprintf("  ID: %d | DNI: %s | %s\n", $e['id'], $e['dni'], $e['nombre']);
        }
    }

    echo "\n";

    // Apoderados y cuántos estudiantes tienen
    echo "Apoderados con número de estudiantes:\n";
    $apoderados_con_count = query("
        SELECT a.id, a.dni, CONCAT(a.apellido_paterno, ' ', a.nombres) as nombre,
               COUNT(ea.id_estudiante) as num_estudiantes
        FROM apoderados a
        LEFT JOIN estudiantes_apoderados ea ON a.id = ea.id_apoderado AND ea.estado = 'activo'
        GROUP BY a.id
        ORDER BY num_estudiantes DESC
    ")->fetchAll();

    foreach ($apoderados_con_count as $a) {
        echo sprintf("  %s - %d estudiante(s)\n", $a['nombre'], $a['num_estudiantes']);
    }

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n";

// 3. Verificar si hay apoderados huérfanos
echo "3. APODERADOS HUÉRFANOS (sin usuario):\n";
echo str_repeat("-", 50) . "\n";

try {
    $huerfanos = query("
        SELECT a.id, a.dni, CONCAT(a.apellido_paterno, ' ', a.nombres) as nombre
        FROM apoderados a
        LEFT JOIN usuarios u ON a.id_usuario = u.id
        WHERE u.id IS NULL
    ")->fetchAll();

    echo "Encontrados: " . count($huerfanos) . "\n";
    if (!empty($huerfanos)) {
        foreach ($huerfanos as $a) {
            echo sprintf("  ID: %d | DNI: %s | %s\n", $a['id'], $a['dni'], $a['nombre']);
        }
    } else {
        echo "  ✓ No hay apoderados huérfanos\n";
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n=== FIN DEL DIAGNÓSTICO ===\n";
echo "</pre>";

echo "<hr>";
echo "<p><a href='limpiar_personal_huerfano.php' class='btn btn-warning'>Limpiar Registros Huérfanos</a></p>";
echo "<p><a href='apoderados/index.php' class='btn btn-primary'>Ir a Apoderados</a></p>";
?>
