-- ============================================
-- MIGRACIÓN: Agregar turnos a horarios
-- Este script agrega soporte para turnos mañana/tarde
-- ============================================

USE SICA2025;

-- Eliminar tabla horarios anterior si existe
DROP TABLE IF EXISTS horarios;

-- ============================================
-- NUEVA TABLA: horarios (con turnos)
-- ============================================
CREATE TABLE IF NOT EXISTS horarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_nivel INT NOT NULL,
    id_anio_lectivo INT NOT NULL,
    turno ENUM('mañana', 'tarde') NOT NULL,
    hora_ingreso TIME NOT NULL,
    hora_salida TIME NOT NULL,
    tolerancia_minutos INT DEFAULT 15,
    estado ENUM('activo', 'inactivo') DEFAULT 'activo',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_nivel_anio (id_nivel, id_anio_lectivo, turno),
    FOREIGN KEY (id_nivel) REFERENCES niveles(id),
    FOREIGN KEY (id_anio_lectivo) REFERENCES anios_lectivos(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- DATOS DE EJEMPLO PARA HORARIOS
-- ============================================

-- Inicial - Mañana
INSERT INTO horarios (id_nivel, id_anio_lectivo, turno, hora_ingreso, hora_salida, tolerancia_minutos)
SELECT 1, id, 'mañana', '08:00:00', '12:00:00', 15 FROM anios_lectivos WHERE estado = 'activo';

-- Primaria - Mañana y Tarde
INSERT INTO horarios (id_nivel, id_anio_lectivo, turno, hora_ingreso, hora_salida, tolerancia_minutos)
SELECT 2, id, 'mañana', '07:30:00', '12:30:00', 15 FROM anios_lectivos WHERE estado = 'activo';

INSERT INTO horarios (id_nivel, id_anio_lectivo, turno, hora_ingreso, hora_salida, tolerancia_minutos)
SELECT 2, id, 'tarde', '13:00:00', '17:30:00', 15 FROM anios_lectivos WHERE estado = 'activo';

-- Secundaria - Mañana y Tarde
INSERT INTO horarios (id_nivel, id_anio_lectivo, turno, hora_ingreso, hora_salida, tolerancia_minutos)
SELECT 3, id, 'mañana', '07:15:00', '13:00:00', 10 FROM anios_lectivos WHERE estado = 'activo';

INSERT INTO horarios (id_nivel, id_anio_lectivo, turno, hora_ingreso, hora_salida, tolerancia_minutos)
SELECT 3, id, 'tarde', '13:30:00', '18:00:00', 10 FROM anios_lectivos WHERE estado = 'activo';
