-- ============================================
-- SICA - Migración: Simplificación de Auxiliares en Programaciones
-- ============================================
-- Cambio: Una sección tiene UN solo auxiliar (no múltiples)

USE SICA2025;

-- Paso 1: Agregar campo id_auxiliar directamente a programaciones
ALTER TABLE programaciones ADD COLUMN id_auxiliar INT NULL AFTER id_tutor;

-- Paso 2: Crear índice
ALTER TABLE programaciones ADD INDEX idx_auxiliar (id_auxiliar);

-- Paso 3: Migrar datos existentes (si los hay)
-- Se queda con el primer auxiliar asignado a cada programación
UPDATE programaciones p
SET id_auxiliar = (
    SELECT id_auxiliar
    FROM programaciones_auxiliares pa
    WHERE pa.id_programacion = p.id AND pa.estado = 'activo'
    LIMIT 1
)
WHERE id_auxiliar IS NULL;

-- Paso 4: Eliminar tabla programaciones_auxiliares (ya no se necesita)
DROP TABLE IF EXISTS programaciones_auxiliares;

-- ============================================
-- FIN DE MIGRACIÓN
-- ============================================
