-- Agregar restricción para evitar huérfanos a nivel de base de datos
-- Un trigger que verifica que id_usuario no sea NULL antes de insertar/actualizar

USE sica2025;

DELIMITER //

-- Trigger para docentes
DROP TRIGGER IF EXISTS before_docentes_insert//
DROP TRIGGER IF EXISTS before_docentes_update//

CREATE TRIGGER before_docentes_insert
BEFORE INSERT ON docentes
FOR EACH ROW
BEGIN
    IF NEW.id_usuario IS NULL OR NEW.id_usuario = 0 THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'El docente debe tener un usuario asociado';
    END IF;
END//

CREATE TRIGGER before_docentes_update
BEFORE UPDATE ON docentes
FOR EACH ROW
BEGIN
    IF NEW.id_usuario IS NULL OR NEW.id_usuario = 0 THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'El docente debe tener un usuario asociado';
    END IF;
END//

-- Trigger para auxiliares
DROP TRIGGER IF EXISTS before_auxiliares_insert//
DROP TRIGGER IF EXISTS before_auxiliares_update//

CREATE TRIGGER before_auxiliares_insert
BEFORE INSERT ON auxiliares
FOR EACH ROW
BEGIN
    IF NEW.id_usuario IS NULL OR NEW.id_usuario = 0 THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'El auxiliar debe tener un usuario asociado';
    END IF;
END//

CREATE TRIGGER before_auxiliares_update
BEFORE UPDATE ON auxiliares
FOR EACH ROW
BEGIN
    IF NEW.id_usuario IS NULL OR NEW.id_usuario = 0 THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'El auxiliar debe tener un usuario asociado';
    END IF;
END//

-- Trigger para apoderados
DROP TRIGGER IF EXISTS before_apoderados_insert//
DROP TRIGGER IF EXISTS before_apoderados_update//

CREATE TRIGGER before_apoderados_insert
BEFORE INSERT ON apoderados
FOR EACH ROW
BEGIN
    IF NEW.id_usuario IS NULL OR NEW.id_usuario = 0 THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'El apoderado debe tener un usuario asociado';
    END IF;
END//

CREATE TRIGGER before_apoderados_update
BEFORE UPDATE ON apoderados
FOR EACH ROW
BEGIN
    IF NEW.id_usuario IS NULL OR NEW.id_usuario = 0 THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'El apoderado debe tener un usuario asociado';
    END IF;
END//

-- Trigger para estudiantes
DROP TRIGGER IF EXISTS before_estudiantes_insert//
DROP TRIGGER IF EXISTS before_estudiantes_update//

CREATE TRIGGER before_estudiantes_insert
BEFORE INSERT ON estudiantes
FOR EACH ROW
BEGIN
    IF NEW.id_usuario IS NULL OR NEW.id_usuario = 0 THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'El estudiante debe tener un usuario asociado';
    END IF;
END//

CREATE TRIGGER before_estudiantes_update
BEFORE UPDATE ON estudiantes
FOR EACH ROW
BEGIN
    IF NEW.id_usuario IS NULL OR NEW.id_usuario = 0 THEN
        SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'El estudiante debe tener un usuario asociado';
    END IF;
END//

DELIMITER ;

-- Verificar triggers creados
SELECT
    TRIGGER_NAME,
    EVENT_MANIPULATION,
    EVENT_OBJECT_TABLE
FROM INFORMATION_SCHEMA.TRIGGERS
WHERE TRIGGER_SCHEMA = 'sica2025'
AND EVENT_OBJECT_TABLE IN ('docentes', 'auxiliares', 'apoderados', 'estudiantes')
ORDER BY EVENT_OBJECT_TABLE, EVENT_MANIPULATION;
