-- ============================================
-- SICA - Migración: Normalizar horarios con turnos
-- ============================================
-- La tabla horarios ahora usará id_turno como FK
-- y los campos hora_ingreso, hora_salida, tolerancia_minutos
-- se obtendrán de la tabla turnos

USE sica2025;

-- Verificar estado actual
SELECT 'ANTES - Horarios:' as info;
SELECT * FROM horarios LIMIT 3;

-- Agregar campo id_turno
ALTER TABLE horarios ADD COLUMN id_turno INT NULL AFTER turno;
ALTER TABLE horarios ADD INDEX idx_id_turno (id_turno);
ALTER TABLE horarios ADD CONSTRAINT fk_horarios_turno FOREIGN KEY (id_turno) REFERENCES turnos(id) ON DELETE SET NULL ON UPDATE CASCADE;

-- Migrar datos: mapear 'mañana' -> 1, 'tarde' -> 2
UPDATE horarios SET id_turno = CASE turno
    WHEN 'mañana' THEN 1
    WHEN 'tarde' THEN 2
    ELSE NULL
END;

-- Verificar migración
SELECT 'VERIFICACIÓN - Horarios con id_turno:' as info;
SELECT
    h.id,
    n.nombre as nivel,
    h.turno as turno_viejo,
    h.id_turno,
    t.nombre as turno_nuevo,
    h.hora_ingreso as hora_ingreso_vieja,
    t.hora_ingreso as hora_ingreso_nueva,
    h.hora_salida as hora_salida_vieja,
    t.hora_salida as hora_salida_nueva
FROM horarios h
INNER JOIN niveles n ON n.id = h.id_nivel
LEFT JOIN turnos t ON t.id = h.id_turno
LIMIT 5;

-- Verificar que todos los horarios tengan id_turno asignado
SELECT 'Horarios SIN id_turno:' as check_info;
SELECT COUNT(*) as total FROM horarios WHERE id_turno IS NULL;

-- Si hay horarios sin id_turno, asignar por defecto
UPDATE horarios SET id_turno = 1 WHERE id_turno IS NULL;

-- Ahora eliminar los campos viejos
ALTER TABLE horarios DROP COLUMN turno;
ALTER TABLE horarios DROP COLUMN hora_ingreso;
ALTER TABLE horarios DROP COLUMN hora_salida;
ALTER TABLE horarios DROP COLUMN tolerancia_minutos;

-- Verificar nueva estructura
SELECT 'DESPUÉS - Nueva estructura de horarios:' as info;
DESCRIBE horarios;

-- Verificación final
SELECT 'VERIFICACIÓN FINAL - Horarios:' as info;
SELECT
    h.id,
    n.nombre as nivel,
    a.anio,
    h.id_turno,
    t.nombre as turno,
    t.abreviatura,
    t.hora_ingreso,
    t.hora_salida,
    t.tolerancia_minutos,
    h.estado
FROM horarios h
INNER JOIN niveles n ON n.id = h.id_nivel
INNER JOIN anios_lectivos a ON a.id = h.id_anio_lectivo
INNER JOIN turnos t ON t.id = h.id_turno
ORDER BY n.nombre, t.nombre;
