-- ============================================
-- MIGRACIÓN: Corrección tabla secciones
-- ============================================
-- Esta migración agrega los campos faltantes id_anio_lectivo y grado
-- para que sea compatible con el código PHP existente

USE sica2025;

-- 1. Agregar campo id_anio_lectivo
ALTER TABLE secciones ADD COLUMN id_anio_lectivo INT NULL AFTER id_turno;

-- 2. Agregar campo grado (VARCHAR redundante para facilitar búsquedas)
ALTER TABLE secciones ADD COLUMN grado VARCHAR(20) NULL AFTER seccion;

-- 3. Agregar foreign key para id_anio_lectivo
ALTER TABLE secciones ADD FOREIGN KEY (id_anio_lectivo) REFERENCES anios_lectivos(id) ON DELETE CASCADE;

-- 4. Actualizar el índice único para incluir id_anio_lectivo
ALTER TABLE secciones DROP INDEX unique_nivel_grado_turno_seccion;
ALTER TABLE secciones ADD UNIQUE KEY unique_nivel_grado_turno_seccion_anio (id_nivel, id_grado, id_turno, seccion, id_anio_lectivo);

-- 5. Actualizar registros existentes con datos de grados y años lectivos
UPDATE secciones s
INNER JOIN grados g ON s.id_grado = g.id
SET s.id_anio_lectivo = g.id_anio_lectivo,
    s.grado = g.grado;

-- 6. Hacer id_anio_lectivo NOT NULL después de actualizar
ALTER TABLE secciones MODIFY COLUMN id_anio_lectivo INT NOT NULL;
ALTER TABLE secciones MODIFY COLUMN grado VARCHAR(20) NOT NULL;

-- ============================================
-- Verificación
-- ============================================
SELECT 'Migración de secciones completada' as mensaje;
SELECT COUNT(*) as secciones_actualizadas FROM secciones WHERE id_anio_lectivo IS NOT NULL;
