-- Migración para normalizar el campo turno en auxiliares
-- Cambiar de ENUM('mañana','tarde','completo') a FK a tabla turnos

-- Paso 1: Agregar columna id_turno
ALTER TABLE auxiliares ADD COLUMN id_turno INT NULL AFTER genero;

-- Paso 2: Migrar datos
-- 'mañana' -> id=1, 'tarde' -> id=2, 'completo' -> NULL (o se puede mantener como texto)
UPDATE auxiliares SET id_turno = 1 WHERE turno = 'mañana';
UPDATE auxiliares SET id_turno = 2 WHERE turno = 'tarde';
UPDATE auxiliares SET id_turno = NULL WHERE turno = 'completo';

-- Paso 3: Agregar FOREIGN KEY
ALTER TABLE auxiliares ADD CONSTRAINT fk_auxiliares_turno
FOREIGN KEY (id_turno) REFERENCES turnos(id) ON DELETE SET NULL;

-- Paso 4: Eliminar columna vieja (opcional, después de verificar)
ALTER TABLE auxiliares DROP COLUMN turno;

-- Paso 5: Hacer id_turno obligatorio si se desea
-- ALTER TABLE auxiliares MODIFY id_turno INT NOT NULL;
