-- Migración: Crear tabla de áreas académicas
-- Fecha: 2025-12-24
-- Descripción: Gestión de áreas académicas por nivel educativo

-- Crear tabla de áreas académicas
CREATE TABLE IF NOT EXISTS `areas_academicas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_nivel` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `area` varchar(100) NOT NULL,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_area` (`id_nivel`, `id_anio_lectivo`, `area`),
  KEY `idx_nivel` (`id_nivel`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `fk_areas_niveles` FOREIGN KEY (`id_nivel`) REFERENCES `niveles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_areas_anios` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Áreas académicas por nivel y año lectivo';

-- Insertar áreas académicas de ejemplo para el año 2025
-- (Asumiendo que existe el año lectivo 2025 con ID 1)

-- Inicial: 3 años, 4 años, 5 años
-- Áreas típicas de nivel inicial
INSERT INTO `areas_academicas` (`id_nivel`, `id_anio_lectivo`, `area`, `estado`) VALUES
-- Para Inicial (id_nivel = 1, asumiendo)
(1, 1, 'Comunicación', 'activo'),
(1, 1, 'Matemática', 'activo'),
(1, 1, 'Personal Social', 'activo'),
(1, 1, 'Ciencia y Ambiente', 'activo'),
(1, 1, 'Arte y Creatividad', 'activo'),
(1, 1, 'Educación Religiosa', 'activo'),
(1, 1, 'Educación Física', 'activo'),
(1, 1, 'Psicomotricidad', 'activo');

-- Primaria: 1° a 6°
-- Áreas típicas de nivel primaria
INSERT INTO `areas_academicas` (`id_nivel`, `id_anio_lectivo`, `area`, `estado`) VALUES
-- Para Primaria (id_nivel = 2, asumiendo)
(2, 1, 'Comunicación', 'activo'),
(2, 1, 'Matemática', 'activo'),
(2, 1, 'Personal Social', 'activo'),
(2, 1, 'Ciencia y Ambiente', 'activo'),
(2, 1, 'Arte y Cultura', 'activo'),
(2, 1, 'Educación Religiosa', 'activo'),
(2, 1, 'Educación Física', 'activo'),
(2, 1, 'Inglés', 'activo'),
(2, 1, 'Computación', 'activo');

-- Secundaria: 1° a 5°
-- Áreas típicas de nivel secundaria
INSERT INTO `areas_academicas` (`id_nivel`, `id_anio_lectivo`, `area`, `estado`) VALUES
-- Para Secundaria (id_nivel = 3, asumiendo)
(3, 1, 'Comunicación', 'activo'),
(3, 1, 'Matemática', 'activo'),
(3, 1, 'Ciencias Sociales', 'activo'),
(3, 1, 'Ciencia, Tecnología y Ambiente', 'activo'),
(3, 1, 'Educación para el Trabajo', 'activo'),
(3, 1, 'Educación Religiosa', 'activo'),
(3, 1, 'Arte', 'activo'),
(3, 1, 'Educación Física', 'activo'),
(3, 1, 'Inglés', 'activo'),
(3, 1, 'Desarrollo Personal, Ciudadanía y Cívica', 'activo'),
(3, 1, 'Filosofía', 'activo'),
(3, 1, 'Biología', 'activo'),
(3, 1, 'Química', 'activo'),
(3, 1, 'Física', 'activo'),
(3, 1, 'Historia del Perú', 'activo'),
(3, 1, 'Geografía', 'activo'),
(3, 1, 'Economía', 'activo');

-- Nota: Los IDs de niveles (1, 2, 3) y año lectivo (1) son ejemplos
-- Ajustar según los datos reales en la base de datos
