-- Migración para crear la tabla de apoderados
-- Fecha: 2025-12-24

-- Crear tabla de apoderados
CREATE TABLE IF NOT EXISTS `apoderados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(11) NOT NULL,
  `dni` varchar(8) NOT NULL,
  `apellido_paterno` varchar(100) NOT NULL,
  `apellido_materno` varchar(100) NOT NULL,
  `nombres` varchar(100) NOT NULL,
  `email` varchar(150) DEFAULT NULL,
  `telefono` varchar(20) NOT NULL,
  `telefono_alternativo` varchar(20) DEFAULT NULL,
  `direccion` varchar(255) DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `genero` enum('M','F') DEFAULT NULL,
  `estado` enum('activo','inactivo','retirado') DEFAULT 'activo',
  `fecha_registro` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_dni` (`dni`),
  UNIQUE KEY `unique_usuario` (`id_usuario`),
  KEY `idx_estado` (`estado`),
  KEY `idx_apellidos` (`apellido_paterno`,`apellido_materno`),
  CONSTRAINT `fk_apoderados_usuario` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Crear tabla de vinculación entre estudiantes y apoderados (para uso futuro)
CREATE TABLE IF NOT EXISTS `estudiantes_apoderados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_estudiante` int(11) NOT NULL,
  `id_apoderado` int(11) NOT NULL,
  `id_anio_lectivo` int(11) NOT NULL,
  `parentesco` varchar(50) DEFAULT 'Padre/Madre',
  `es_principal` tinyint(1) DEFAULT 0,
  `estado` enum('activo','inactivo') DEFAULT 'activo',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_estudiante_anio` (`id_estudiante`,`id_anio_lectivo`),
  KEY `idx_estudiante` (`id_estudiante`),
  KEY `idx_apoderado` (`id_apoderado`),
  KEY `idx_anio_lectivo` (`id_anio_lectivo`),
  KEY `idx_estado` (`estado`),
  CONSTRAINT `fk_estudiantes_apoderados_estudiante` FOREIGN KEY (`id_estudiante`) REFERENCES `estudiantes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_estudiantes_apoderados_apoderado` FOREIGN KEY (`id_apoderado`) REFERENCES `apoderados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_estudiantes_apoderados_anio` FOREIGN KEY (`id_anio_lectivo`) REFERENCES `anios_lectivos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
