-- =============================================
-- Limpiar apoderado DNI 41675960 completamente
-- =============================================
-- Este script elimina tanto el apoderado como el usuario asociado

USE SICA2025;

-- Verificar qué existe
SELECT 'Apoderado:' as tipo, id, dni, apellido_paterno, apellido_materno FROM apoderados WHERE dni = '41675960'
UNION ALL
SELECT 'Usuario:', id, usuario, '', '' FROM usuarios WHERE usuario = '41675960';

-- 1. Eliminar apoderado (esto NO elimina el usuario automáticamente debido a ON DELETE SET NULL)
DELETE FROM apoderados WHERE dni = '41675960';

-- 2. Eliminar el usuario
DELETE FROM usuarios WHERE usuario = '41675960';

-- Verificar que se eliminó correctamente
SELECT 'Verificación - debe estar vacío:' as mensaje;
SELECT COUNT(*) as apoderados_restantes FROM apoderados WHERE dni = '41675960';
SELECT COUNT(*) as usuarios_restantes FROM usuarios WHERE usuario = '41675960';
