-- ============================================
-- SICA - Fix v3: Unificar collation a utf8mb4_general_ci
-- ============================================

USE sica2025;

-- PASO 1: Eliminar campo nuevamente
ALTER TABLE programaciones DROP COLUMN turno;

-- PASO 2: Recrear con utf8mb4_general_ci (como las otras tablas)
ALTER TABLE programaciones
ADD COLUMN turno ENUM('mañana','tarde')
CHARACTER SET utf8mb4
COLLATE utf8mb4_general_ci
DEFAULT 'mañana'
AFTER id_auxiliar;

-- PASO 3: Actualizar usando índices del enum
UPDATE programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
SET p.turno = CASE s.turno
    WHEN 'mañana' THEN 1
    WHEN 'tarde' THEN 2
    ELSE 1
END;

-- PASO 4: Verificar HEX (deben ser iguales ahora)
SELECT
    p.id,
    p.turno as prog_turno,
    HEX(p.turno) as prog_hex,
    s.turno as secc_turno,
    HEX(s.turno) as secc_hex,
    CASE
        WHEN HEX(p.turno) = HEX(s.turno) THEN '✓ CORRECTO - HEX IGUALES'
        ELSE '✗ DIFERENTE'
    END as estado
FROM programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
LIMIT 3;
