-- ============================================
-- SICA - Fix Definitivo: Campo turno en programaciones
-- ============================================
-- Ejecutar este script en phpMyAdmin o consola MySQL

USE sica2025;

-- PASO 1: Verificar estado actual
SELECT 'ANTES:' as info;
SELECT
    p.id,
    p.turno as prog_turno,
    HEX(p.turno) as prog_hex,
    s.turno as secc_turno,
    HEX(s.turno) as secc_hex
FROM programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
LIMIT 3;

-- PASO 2: Eliminar campo problemático
ALTER TABLE programaciones DROP COLUMN turno;

-- PASO 3: Recrear campo con encoding correcto
ALTER TABLE programaciones
ADD COLUMN turno ENUM('mañana','tarde')
CHARACTER SET utf8mb4
COLLATE utf8mb4_unicode_ci
DEFAULT 'mañana'
AFTER id_auxiliar;

-- PASO 4: Actualizar todos los registros con el valor correcto
-- Usamos el índice del ENUM: 1 = 'mañana', 2 = 'tarde'
UPDATE programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
SET p.turno = CASE s.turno
    WHEN 'mañana' THEN 1
    WHEN 'tarde' THEN 2
    ELSE 1
END;

-- PASO 5: Verificar que funcionó
SELECT 'DESPUÉS:' as info;
SELECT
    p.id,
    p.turno as prog_turno,
    HEX(p.turno) as prog_hex,
    s.turno as secc_turno,
    HEX(s.turno) as secc_hex,
    CASE
        WHEN HEX(p.turno) = HEX(s.turno) THEN '✓ CORRECTO'
        ELSE '✗ AÚN MAL'
    END as estado
FROM programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
LIMIT 3;

-- PASO 6: Verificar que JOIN funciona
SELECT
    p.id,
    s.grado,
    s.seccion,
    p.turno,
    h.hora_ingreso,
    h.hora_salida
FROM programaciones p
INNER JOIN secciones s ON s.id = p.id_seccion
LEFT JOIN horarios h ON h.id_nivel = s.id_nivel
    AND h.id_anio_lectivo = p.id_anio_lectivo
    AND h.turno = p.turno
LIMIT 3;
