-- ============================================
-- SICA - DATOS BÁSICOS COMPLETOS
-- Script para insertar todos los datos necesarios
-- para que el sistema funcione correctamente
-- ============================================

USE sica2025;

-- ============================================
-- 1. USUARIO ADMINISTRADOR POR DEFECTO
-- ============================================
-- Usuario: admin
-- Contraseña: password (debe cambiarla después)
INSERT INTO usuarios (usuario, password, rol, estado, fecha_registro) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'activo', NOW());

-- ============================================
-- 2. AÑOS LECTIVOS
-- ============================================
INSERT INTO anios_lectivos (anio, fecha_inicio, fecha_fin, estado) VALUES
('2025', '2025-03-03', '2025-12-20', 'activo'),
('2026', '2026-03-02', '2026-12-19', 'inactivo'),
('2027', '2027-03-01', '2027-12-18', 'inactivo');

-- ============================================
-- 3. NIVELES EDUCATIVOS
-- ============================================
INSERT INTO niveles (nombre, estado) VALUES
('Inicial', 'activo'),
('Primaria', 'activo'),
('Secundaria', 'activo');

-- ============================================
-- 4. TURNOS (con horarios y tolerancia)
-- ============================================
INSERT INTO turnos (nombre, abreviatura, hora_ingreso, hora_salida, tolerancia_minutos, estado) VALUES
('Mañana', 'MAÑ', '07:00:00', '12:00:00', 15, 'activo'),
('Tarde', 'TAR', '13:00:00', '18:00:00', 15, 'activo');

-- ============================================
-- 5. GRADOS POR NIVEL Y AÑO LECTIVO
-- ============================================

-- Inicial (año 2025)
INSERT INTO grados (id_nivel, id_anio_lectivo, grado, estado) VALUES
(1, 1, '3 años', 'activo'),
(1, 1, '4 años', 'activo'),
(1, 1, '5 años', 'activo');

-- Primaria (año 2025)
INSERT INTO grados (id_nivel, id_anio_lectivo, grado, estado) VALUES
(2, 1, '1°', 'activo'),
(2, 1, '2°', 'activo'),
(2, 1, '3°', 'activo'),
(2, 1, '4°', 'activo'),
(2, 1, '5°', 'activo'),
(2, 1, '6°', 'activo');

-- Secundaria (año 2025)
INSERT INTO grados (id_nivel, id_anio_lectivo, grado, estado) VALUES
(3, 1, '1°', 'activo'),
(3, 1, '2°', 'activo'),
(3, 1, '3°', 'activo'),
(3, 1, '4°', 'activo'),
(3, 1, '5°', 'activo');

-- Inicial (año 2026)
INSERT INTO grados (id_nivel, id_anio_lectivo, grado, estado) VALUES
(1, 2, '3 años', 'activo'),
(1, 2, '4 años', 'activo'),
(1, 2, '5 años', 'activo');

-- Primaria (año 2026)
INSERT INTO grados (id_nivel, id_anio_lectivo, grado, estado) VALUES
(2, 2, '1°', 'activo'),
(2, 2, '2°', 'activo'),
(2, 2, '3°', 'activo'),
(2, 2, '4°', 'activo'),
(2, 2, '5°', 'activo'),
(2, 2, '6°', 'activo');

-- Secundaria (año 2026)
INSERT INTO grados (id_nivel, id_anio_lectivo, grado, estado) VALUES
(3, 2, '1°', 'activo'),
(3, 2, '2°', 'activo'),
(3, 2, '3°', 'activo'),
(3, 2, '4°', 'activo'),
(3, 2, '5°', 'activo');

-- ============================================
-- 6. SECCIONES (por nivel, grado y turno)
-- ============================================

-- Inicial - Mañana
INSERT INTO secciones (id_nivel, id_grado, id_turno, id_anio_lectivo, seccion, grado, capacidad, estado) VALUES
-- 3 años
(1, 1, 1, 1, 'A', '3 años', 25, 'activo'),
(1, 1, 1, 1, 'B', '3 años', 25, 'activo'),
-- 4 años
(1, 2, 1, 1, 'A', '4 años', 25, 'activo'),
(1, 2, 1, 1, 'B', '4 años', 25, 'activo'),
-- 5 años
(1, 3, 1, 1, 'A', '5 años', 25, 'activo'),
(1, 3, 1, 1, 'B', '5 años', 25, 'activo');

-- Inicial - Tarde
INSERT INTO secciones (id_nivel, id_grado, id_turno, id_anio_lectivo, seccion, grado, capacidad, estado) VALUES
-- 3 años
(1, 1, 2, 1, 'A', '3 años', 25, 'activo'),
-- 4 años
(1, 2, 2, 1, 'A', '4 años', 25, 'activo'),
-- 5 años
(1, 3, 2, 1, 'A', '5 años', 25, 'activo');

-- Primaria - Mañana
INSERT INTO secciones (id_nivel, id_grado, id_turno, id_anio_lectivo, seccion, grado, capacidad, estado) VALUES
-- 1°
(2, 4, 1, 1, 'A', '1°', 30, 'activo'),
(2, 4, 1, 1, 'B', '1°', 30, 'activo'),
(2, 4, 1, 1, 'C', '1°', 30, 'activo'),
-- 2°
(2, 5, 1, 1, 'A', '2°', 30, 'activo'),
(2, 5, 1, 1, 'B', '2°', 30, 'activo'),
(2, 5, 1, 1, 'C', '2°', 30, 'activo'),
-- 3°
(2, 6, 1, 1, 'A', '3°', 30, 'activo'),
(2, 6, 1, 1, 'B', '3°', 30, 'activo'),
(2, 6, 1, 1, 'C', '3°', 30, 'activo'),
-- 4°
(2, 7, 1, 1, 'A', '4°', 30, 'activo'),
(2, 7, 1, 1, 'B', '4°', 30, 'activo'),
(2, 7, 1, 1, 'C', '4°', 30, 'activo'),
-- 5°
(2, 8, 1, 1, 'A', '5°', 30, 'activo'),
(2, 8, 1, 1, 'B', '5°', 30, 'activo'),
(2, 8, 1, 1, 'C', '5°', 30, 'activo'),
-- 6°
(2, 9, 1, 1, 'A', '6°', 30, 'activo'),
(2, 9, 1, 1, 'B', '6°', 30, 'activo'),
(2, 9, 1, 1, 'C', '6°', 30, 'activo');

-- Primaria - Tarde
INSERT INTO secciones (id_nivel, id_grado, id_turno, id_anio_lectivo, seccion, grado, capacidad, estado) VALUES
-- 1°
(2, 4, 2, 1, 'A', '1°', 30, 'activo'),
(2, 4, 2, 1, 'B', '1°', 30, 'activo'),
-- 2°
(2, 5, 2, 1, 'A', '2°', 30, 'activo'),
(2, 5, 2, 1, 'B', '2°', 30, 'activo'),
-- 3°
(2, 6, 2, 1, 'A', '3°', 30, 'activo'),
(2, 6, 2, 1, 'B', '3°', 30, 'activo'),
-- 4°
(2, 7, 2, 1, 'A', '4°', 30, 'activo'),
(2, 7, 2, 1, 'B', '4°', 30, 'activo'),
-- 5°
(2, 8, 2, 1, 'A', '5°', 30, 'activo'),
(2, 8, 2, 1, 'B', '5°', 30, 'activo'),
-- 6°
(2, 9, 2, 1, 'A', '6°', 30, 'activo'),
(2, 9, 2, 1, 'B', '6°', 30, 'activo');

-- Secundaria - Mañana
INSERT INTO secciones (id_nivel, id_grado, id_turno, id_anio_lectivo, seccion, grado, capacidad, estado) VALUES
-- 1°
(3, 10, 1, 1, 'A', '1°', 35, 'activo'),
(3, 10, 1, 1, 'B', '1°', 35, 'activo'),
(3, 10, 1, 1, 'C', '1°', 35, 'activo'),
-- 2°
(3, 11, 1, 1, 'A', '2°', 35, 'activo'),
(3, 11, 1, 1, 'B', '2°', 35, 'activo'),
(3, 11, 1, 1, 'C', '2°', 35, 'activo'),
-- 3°
(3, 12, 1, 1, 'A', '3°', 35, 'activo'),
(3, 12, 1, 1, 'B', '3°', 35, 'activo'),
(3, 12, 1, 1, 'C', '3°', 35, 'activo'),
-- 4°
(3, 13, 1, 1, 'A', '4°', 35, 'activo'),
(3, 13, 1, 1, 'B', '4°', 35, 'activo'),
(3, 13, 1, 1, 'C', '4°', 35, 'activo'),
-- 5°
(3, 14, 1, 1, 'A', '5°', 35, 'activo'),
(3, 14, 1, 1, 'B', '5°', 35, 'activo'),
(3, 14, 1, 1, 'C', '5°', 35, 'activo');

-- Secundaria - Tarde
INSERT INTO secciones (id_nivel, id_grado, id_turno, id_anio_lectivo, seccion, grado, capacidad, estado) VALUES
-- 1°
(3, 10, 2, 1, 'A', '1°', 35, 'activo'),
(3, 10, 2, 1, 'B', '1°', 35, 'activo'),
-- 2°
(3, 11, 2, 1, 'A', '2°', 35, 'activo'),
(3, 11, 2, 1, 'B', '2°', 35, 'activo'),
-- 3°
(3, 12, 2, 1, 'A', '3°', 35, 'activo'),
(3, 12, 2, 1, 'B', '3°', 35, 'activo'),
-- 4°
(3, 13, 2, 1, 'A', '4°', 35, 'activo'),
(3, 13, 2, 1, 'B', '4°', 35, 'activo'),
-- 5°
(3, 14, 2, 1, 'A', '5°', 35, 'activo'),
(3, 14, 2, 1, 'B', '5°', 35, 'activo');

-- ============================================
-- 7. HORARIOS (asignación de turnos a niveles)
-- ============================================
INSERT INTO horarios (id_nivel, id_anio_lectivo, id_turno, estado) VALUES
-- Inicial
(1, 1, 1, 'activo'),
(1, 1, 2, 'activo'),
-- Primaria
(2, 1, 1, 'activo'),
(2, 1, 2, 'activo'),
-- Secundaria
(3, 1, 1, 'activo'),
(3, 1, 2, 'activo');

-- ============================================
-- 8. ESTADOS DE ASISTENCIA
-- ============================================
INSERT INTO estados_asistencia (nombre, abreviatura, descripcion, color, icono, conteo_asistencia, permite_tardanza, requiere_justificacion, estado) VALUES
('Asistencia', 'ASI', 'Asistencia completa y puntual', '#10b981', 'check-circle-fill', 'si', 'no', 'no', 'activo'),
('Tardanza', 'TAR', 'Llegó después de la hora de ingreso', '#f59e0b', 'clock-fill', 'si', 'si', 'no', 'activo'),
('Tardanza Justificada', 'TJU', 'Tardanza con justificación documentada', '#3b82f6', 'clock-history', 'si', 'si', 'si', 'activo'),
('Falta Justificada', 'FJU', 'Falta con justificación documentada', '#8b5cf6', 'check-square', 'no', 'no', 'si', 'activo'),
('Falta Injustificada', 'FIN', 'Falta sin justificación', '#ef4444', 'x-circle-fill', 'no', 'no', 'no', 'activo'),
('Excusado', 'EXC', 'Estudiante excusado por la institución', '#06b6d4', 'shield-check', 'no', 'no', 'no', 'activo'),
('Licencia', 'LIC', 'Licencia médica o autorización', '#ec4899', 'file-medical', 'no', 'no', 'si', 'activo');

-- ============================================
-- 9. TIPOS DE INCIDENCIA
-- ============================================
INSERT INTO tipos_incidencia (tipo, descripcion, gravedad, puntos_penalidad, estado) VALUES
('Falta de respeto', 'Falta de respeto hacia compañeros o personal', 'media', 5, 'activo'),
('Agresión física', 'Cualquier tipo de agresión física', 'muy_alta', 20, 'activo'),
('Agresión verbal', 'Insultos o palabras ofensivas', 'alta', 10, 'activo'),
('Daño a la propiedad', 'Daño intencional a propiedad de la institución o compañeros', 'alta', 15, 'activo'),
('Incumplimiento de tareas', 'No entrega de tareas o trabajos asignados', 'baja', 2, 'activo'),
('Inasistencia repetida', 'Faltas injustificadas repetidas', 'media', 5, 'activo'),
('Uso inapropiado de tecnología', 'Uso inadecuado de dispositivos tecnológicos', 'media', 5, 'activo'),
('Comportamiento disruptivo', 'Interrupción constante del desarrollo de clases', 'media', 3, 'activo'),
('Bullying', 'Acoso escolar a compañeros', 'muy_alta', 25, 'activo'),
('Fraude académico', 'Copiar o hacer trampa en exámenes', 'alta', 10, 'activo');

-- ============================================
-- 10. ÁREAS ACADÉMICAS (por nivel y año)
-- ============================================

-- Inicial (año 2025)
INSERT INTO areas_academicas (id_nivel, id_anio_lectivo, area, estado) VALUES
(1, 1, 'Comunicación', 'activo'),
(1, 1, 'Matemática', 'activo'),
(1, 1, 'Personal Social', 'activo'),
(1, 1, 'Ciencia y Ambiente', 'activo'),
(1, 1, 'Arte y Cultura', 'activo'),
(1, 1, 'Educación Física', 'activo'),
(1, 1, 'Educación Religiosa', 'activo');

-- Primaria (año 2025)
INSERT INTO areas_academicas (id_nivel, id_anio_lectivo, area, estado) VALUES
(2, 1, 'Comunicación', 'activo'),
(2, 1, 'Matemática', 'activo'),
(2, 1, 'Personal Social', 'activo'),
(2, 1, 'Ciencia y Ambiente', 'activo'),
(2, 1, 'Arte y Cultura', 'activo'),
(2, 1, 'Educación Física', 'activo'),
(2, 1, 'Educación Religiosa', 'activo'),
(2, 1, 'Inglés', 'activo'),
(2, 1, 'Computación', 'activo');

-- Secundaria (año 2025)
INSERT INTO areas_academicas (id_nivel, id_anio_lectivo, area, estado) VALUES
(3, 1, 'Comunicación', 'activo'),
(3, 1, 'Matemática', 'activo'),
(3, 1, 'Ciencias Sociales', 'activo'),
(3, 1, 'Ciencia, Tecnología y Ambiente', 'activo'),
(3, 1, 'Educación para el Trabajo', 'activo'),
(3, 1, 'Educación Física', 'activo'),
(3, 1, 'Educación Religiosa', 'activo'),
(3, 1, 'Inglés', 'activo'),
(3, 1, 'Arte y Cultura', 'activo'),
(3, 1, 'Desarrollo Personal, Ciudadanía y Cívica', 'activo'),
(3, 1, 'Filosofía', 'activo'),
(3, 1, 'Física', 'activo'),
(3, 1, 'Química', 'activo'),
(3, 1, 'Biología', 'activo'),
(3, 1, 'Historia', 'activo'),
(3, 1, 'Geografía', 'activo'),
(3, 1, 'Economía', 'activo');

-- ============================================
-- 11. CALENDARIO (Feriados 2025 - por año lectivo)
-- ============================================
INSERT INTO calendario (fecha, tipo, nombre, descripcion, aniolectivo_id, afecta_todos_niveles, estado) VALUES
-- Enero
('2025-01-01', 'feriado', 'Año Nuevo', 'Año Nuevo', 1, TRUE, 'activo'),
-- Marzo (Semana Santa 2025)
('2025-04-10', 'feriado', 'Jueves Santo', 'Jueves Santo', 1, TRUE, 'activo'),
('2025-04-11', 'feriado', 'Viernes Santo', 'Viernes Santo', 1, TRUE, 'activo'),
-- Mayo
('2025-05-01', 'feriado', 'Día del Trabajo', 'Día del Trabajo', 1, TRUE, 'activo'),
-- Junio
('2025-06-29', 'feriado', 'San Pedro y San Pablo', 'San Pedro y San Pablo', 1, TRUE, 'activo'),
-- Julio (Fiestas Patrias)
('2025-07-28', 'feriado', 'Fiestas Patrias - Día 1', 'Día de la Independencia', 1, TRUE, 'activo'),
('2025-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', 1, TRUE, 'activo'),
-- Agosto
('2025-08-30', 'feriado', 'Santa Rosa de Lima', 'Santa Rosa de Lima', 1, TRUE, 'activo'),
-- Octubre
('2025-10-08', 'feriado', 'Combate de Angamos', 'Combate de Angamos', 1, TRUE, 'activo'),
-- Noviembre
('2025-11-01', 'feriado', 'Todos los Santos', 'Todos los Santos', 1, TRUE, 'activo'),
-- Diciembre
('2025-12-08', 'feriado', 'Inmaculada Concepción', 'Inmaculada Concepción', 1, TRUE, 'activo'),
('2025-12-25', 'feriado', 'Navidad', 'Navidad', 1, TRUE, 'activo');

-- ============================================
-- 12. PARÁMETROS DE CONFIGURACIÓN
-- ============================================
INSERT INTO configuracion (parametro, valor, descripcion) VALUES
('anio_lectivo_activo', '1', 'Año lectivo actualmente activo (ID)'),
('intervalo_notificacion_inasistencia', '90', 'Intervalo en minutos para notificar ausencia automática'),
('tolerancia_default', '15', 'Tolerancia en minutos por defecto para tardanzas'),
('max_faltas_riesgo', '10', 'Número máximo de faltas injustificadas antes de alerta de riesgo'),
('max_tardanzas_riesgo', '15', 'Número máximo de tardanzas antes de alerta de riesgo'),
('max_incidencias_riesgo', '5', 'Número máximo de incidencias graves antes de alerta de riesgo'),
('email_sistema', 'notificaciones@sica.edu', 'Correo electrónico del sistema para envío de notificaciones'),
('nombre_institucion', 'SICA - Sistema Integrado de Convivencia y Asistencia', 'Nombre de la institución educativa'),
('telefono_institucion', '(01) 123-4567', 'Teléfono de la institución'),
('direccion_institucion', 'Av. Principal 123, Lima, Perú', 'Dirección de la institución');

-- ============================================
-- 13. USUARIOS DE PRUEBA (opcional)
-- ============================================
-- Docente de prueba
INSERT INTO usuarios (usuario, password, rol, estado, fecha_registro) VALUES
('docente1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'docente', 'activo', NOW()),
('auxiliar1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'auxiliar', 'activo', NOW());

INSERT INTO docentes (id_usuario, dni, apellido_paterno, apellido_materno, nombres, email, telefono, especialidad, estado) VALUES
(2, '12345671', 'Rodríguez', 'Martínez', 'Carlos Alberto', 'carlos.rodriguez@sica.edu', '987654321', 'Matemática y Física', 'activo');

INSERT INTO auxiliares (id_usuario, dni, apellido_paterno, apellido_materno, nombres, email, telefono, estado) VALUES
(3, '12345672', 'López', 'García', 'María Elena', 'maria.lopez@sica.edu', '987654322', 'activo');

-- Estudiante de prueba
INSERT INTO usuarios (usuario, password, rol, estado, fecha_registro) VALUES
('estudiante1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'estudiante', 'activo', NOW());

INSERT INTO estudiantes (id_usuario, dni, apellido_paterno, apellido_materno, nombres, fecha_nacimiento, genero, telefono, direccion, estado) VALUES
(4, '12345678', 'Pérez', 'García', 'Juan Carlos', '2010-05-15', 'M', '987654320', 'Av. Las Flores 123', 'activo');

-- Apoderado de prueba
INSERT INTO usuarios (usuario, password, rol, estado, fecha_registro) VALUES
('apoderado1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'apoderado', 'activo', NOW());

INSERT INTO apoderados (id_usuario, dni, apellido_paterno, apellido_materno, nombres, email, telefono, telefono_alternativo, direccion, estado) VALUES
(5, '12345673', 'Pérez', 'García', 'Roberto Carlos', 'roberto.perez@email.com', '987654319', '987654318', 'Av. Las Flores 123', 'activo');

-- Vincular estudiante con apoderado
INSERT INTO estudiantes_apoderados (id_estudiante, id_apoderado, id_anio_lectivo, parentesco, es_principal, estado) VALUES
(1, 1, 1, 'Padre', TRUE, 'activo');

-- ============================================
-- RESUMEN DE DATOS INSERTADOS
-- ============================================
SELECT 'DATOS BÁSICOS INSERTADOS CORRECTAMENTE' as mensaje;
SELECT '====================================' as separador;

-- Contadores
SELECT 'Años lectivos' as concepto, COUNT(*) as total FROM anios_lectivos
UNION ALL
SELECT 'Niveles', COUNT(*) FROM niveles
UNION ALL
SELECT 'Turnos', COUNT(*) FROM turnos
UNION ALL
SELECT 'Grados', COUNT(*) FROM grados
UNION ALL
SELECT 'Secciones', COUNT(*) FROM secciones
UNION ALL
SELECT 'Horarios', COUNT(*) FROM horarios
UNION ALL
SELECT 'Estados de asistencia', COUNT(*) FROM estados_asistencia
UNION ALL
SELECT 'Tipos de incidencia', COUNT(*) FROM tipos_incidencia
UNION ALL
SELECT 'Áreas académicas', COUNT(*) FROM areas_academicas
UNION ALL
SELECT 'Feriados 2025', COUNT(*) FROM calendario WHERE aniolectivo_id = 1
UNION ALL
SELECT 'Parámetros de configuración', COUNT(*) FROM configuracion
UNION ALL
SELECT 'Usuarios', COUNT(*) FROM usuarios
UNION ALL
SELECT 'Estudiantes', COUNT(*) FROM estudiantes
UNION ALL
SELECT 'Docentes', COUNT(*) FROM docentes
UNION ALL
SELECT 'Auxiliares', COUNT(*) FROM auxiliares
UNION ALL
SELECT 'Apoderados', COUNT(*) FROM apoderados;
