-- ============================================
-- ACTUALIZACIÓN: Convertir Feriados a Globales
-- Fecha: 2025-12-28
-- Descripción: Convierte los feriados existentes en globales (aniolectivo_id = NULL)
-- ============================================
--
-- EJECUTAR ESTE SCRIPT SI:
-- 1. Ya ejecutó migracion_calendario.sql anteriormente
-- 2. Los feriados tienen aniolectivo_id con valor específico en lugar de NULL
-- 3. Quiere que los feriados nacionales apliquen a todos los años lectivos
--
-- ============================================

-- Paso 1: Convertir feriados nacionales y días no laborales a globales
UPDATE calendario
SET aniolectivo_id = NULL
WHERE tipo IN ('feriado', 'dia_no_laboral', 'fin_semana_largo')
AND afecta_todos_niveles = TRUE;

-- Paso 2: Agregar feriado de Fiestas Patrias Día 2 (29 de julio) si no existe
INSERT IGNORE INTO calendario (fecha, tipo, nombre, descripcion, aniolectivo_id, afecta_todos_niveles)
VALUES ('2025-07-29', 'feriado', 'Fiestas Patrias - Día 2', 'Gran Parada Militar', NULL, TRUE);

-- Paso 3: Verificar resultados
SELECT
    fecha,
    tipo,
    nombre,
    CASE
        WHEN aniolectivo_id IS NULL THEN 'GLOBAL (todos los años)'
        ELSE CONCAT('Específico (año lectivo ID: ', aniolectivo_id, ')')
    END AS alcance,
    afecta_todos_niveles
FROM calendario
WHERE estado = 'activo'
ORDER BY fecha;

-- ============================================
-- RESULTADO ESPERADO:
-- Debería ver "GLOBAL (todos los años)" en la columna alcance
-- para todos los feriados nacionales (Año Nuevo, Fiestas Patrias, etc.)
-- ============================================
