# SICA - Guía de Instalación en Hosting

## Archivos Generados

El script `exportar_db.php` ha generado los siguientes archivos:

1. **SICA2025_PRODUCCION_YYYY-MM-DD_HHMMSS.sql** - Archivo SQL completo (≈53 KB)
2. **SICA2025_PRODUCCION_YYYY-MM-DD_HHMMSS.sql.gz** - Versión comprimida (≈8 KB)

## Características del SQL Exportado

✅ **Compatible con MySQL 5.7+ y MariaDB 10.2+**
✅ **Corrige automáticamente problemas con:**
   - Funciones `CURDATE()` y `CURRENT_TIMESTAMP` → `current_timestamp()`
   - Campos ENUM (codificados correctamente en UTF-8)
   - Definer de vistas (`root@localhost` → sin problemas de permisos)
   - Auto-increment (limpiado para nueva instalación)

✅ **Incluye:**
   - 25 tablas con estructura y datos
   - 4 vistas (creadas al final para evitar dependencias)
   - Todas las foreign keys y restricciones
   - Índices optimizados

## Instrucciones de Instalación en Hosting

### Opción 1: Usando phpMyAdmin (Recomendado para bases < 50 MB)

1. **Acceder a phpMyAdmin** en tu hosting
   - Generalmente: `http://tu-dominio.com/phpmyadmin`
   - O desde cPanel → Databases → phpMyAdmin

2. **Crear la base de datos:**
   - Clic en "Nueva base de datos" o "New database"
   - Nombre: `SICA2025` (u otro nombre)
   - Cotejamiento: `utf8mb4_unicode_ci`

3. **Importar el archivo:**
   - Seleccionar la base de datos creada
   - Clic en la pestaña "Importar"
   - Elegir el archivo: `SICA2025_PRODUCCION_*.sql`
   - Clic en "Importar" o "Go"

4. **Verificar:**
   - Deberías ver 29 objetos (25 tablas + 4 vistas)
   - Sin errores de importación

### Opción 2: Usando SSH/Console (Más rápido para bases grandes)

```bash
# Subir el archivo .sql.gz al servidor
scp SICA2025_PRODUCCION_*.sql.gz usuario@tu-hosting.com:~

# Conectar por SSH
ssh usuario@tu-hosting.com

# Descomprimir
gunzip SICA2025_PRODUCCION_*.sql.gz

# Importar
mysql -u usuario_bd -p nombre_bd < SICA2025_PRODUCCION_*.sql
```

### Opción 3: Usando script PHP (Si no tienes acceso SSH)

1. **Subir el archivo SQL** al hosting (vía FTP o FileManager)
2. **Crear un script PHP** temporal:

```php
<?php
// importar_db.php
$host = 'localhost';
$user = 'usuario_bd';      // CAMBIAR
$pass = 'contraseña_bd';    // CAMBIAR
$dbname = 'SICA2025';       // CAMBIAR si es necesario
$sql_file = 'SICA2025_PRODUCCION_2025-12-28_215207.sql'; // CAMBIAR nombre

try {
    $pdo = new PDO("mysql:host=$host", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Crear base de datos si no existe
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    $pdo->exec("USE `$dbname`");

    // Leer archivo SQL
    $sql = file_get_contents($sql_file);

    // Ejecutar (dividir por statements para evitar límites)
    $statements = explode(';', $sql);
    $count = 0;

    foreach ($statements as $statement) {
        $statement = trim($statement);
        if (!empty($statement)) {
            $pdo->exec($statement);
            $count++;
        }
    }

    echo "✓ Importación completada: $count statements ejecutados\n";

} catch (PDOException $e) {
    die("Error: " . $e->getMessage() . "\n");
}
?>
```

3. **Ejecutar desde el navegador:**
   - `http://tu-dominio.com/importar_db.php`

4. **Eliminar el script** después de la importación (¡seguridad!)

## Configurar Conexión en el Hosting

Después de importar, actualiza la configuración:

### Archivo: `config/db.php`

```php
<?php
define('DB_HOST', 'localhost');          // Usualmente localhost
define('DB_NAME', 'SICA2025');           // Nombre de tu BD
define('DB_USER', 'usuario_bd');         // Usuario de BD del hosting
define('DB_PASS', 'contraseña_bd');      // Contraseña del hosting
define('DB_CHARSET', 'utf8mb4');
```

## Verificar Instalación

1. **Subir los archivos del proyecto SICA** al hosting (vía FTP o Git)
2. **Acceder a la URL**: `http://tu-dominio.com/login.php`
3. **Usuario por defecto:**
   - Usuario: `admin`
   - Contraseña: `password` (o la que hayas configurado)

## Problemas Comunes y Soluciones

### Error: "Unknown database 'SICA2025'"
**Solución:** Crear la base de datos primero en phpMyAdmin

### Error: "Access denied for user 'root'@'localhost'"
**Solución:** Usar las credenciales de BD del hosting (no root)
- Revisar email de bienvenida del hosting
- O crear un nuevo usuario BD en cPanel

### Error: "Definer='root@localhost'"
**Solución:** El SQL ya está corregido. Si persiste:
```sql
-- Ejecutar en phpMyAdmin:
UPDATE mysql.proc SET DEFINER = 'CURRENT_USER' WHERE DEFINER = 'root@localhost';
FLUSH PRIVILEGES;
```

### Error de codificación (ñ o acentos mal)
**Solución:** Asegúrate de:
- La BD tiene cotejamiento `utf8mb4_unicode_ci`
- Las tablas también tienen `utf8mb4_unicode_ci`
- El archivo PHP de conexión usa `charset=utf8mb4`

## Regenerar el SQL

Si necesitas regenerar el SQL (por cambios en la BD local):

```bash
cd c:\xampp\htdocs\SICA\database
php exportar_db.php
```

Se generará un nuevo archivo con timestamp actual.

## Estructura de la Base de Datos

### Tablas Principales (25):
- `usuarios` - Usuarios del sistema
- `estudiantes` - Datos de estudiantes
- `apoderados` - Apoderados/tutores
- `docentes` - Docentes
- `auxiliares` - Auxiliares de educación
- `anios_lectivos` - Años escolares (2025, 2026, etc.)
- `niveles` - Niveles educativos (Inicial, Primaria, Secundaria)
- `grados` - Grados por nivel
- `secciones` - Secciones (A, B, C, etc.)
- `turnos` - Turnos (Mañana, Tarde)
- `programaciones` - Programación por sección/año
- `programaciones_estudiantes` - Estudiantes en cada programación
- `programaciones_docentes_areas` - Áreas asignadas a docentes
- `areas_academicas` - Áreas por nivel (Matemática, Comunicación, etc.)
- `horarios` - Asignación de turnos a niveles
- `estados_asistencia` - Tipos de asistencia (Asistencia, Tardanza, Falta, etc.)
- `asistencias` - Registros de asistencia
- `calendario` - Feriados, vacaciones, días no laborables
- `notificaciones` - Notificaciones a apoderados
- `incidencias` - Incidencias/inconductas
- `tipos_incidencia` - Tipos de incidencias
- `configuracion` - Parámetros del sistema
- `estudiantes_apoderados` - Relación estudiante-apoderado
- `docente_areas` - Áreas de docentes
- `notificaciones_email` - Historial de envíos

### Vistas (4):
- `v_asistencias_detalle` - Vista completa de asistencias
- `v_calendario_detalle` - Calendario con información adicional
- `v_estudiantes_programacion` - Estudiantes con su programación
- `v_programaciones_resumen` - Resumen de programaciones

## Soporte

Si encuentras algún problema no documentado aquí:
1. Revisa el archivo de logs: `tareas/logs/verificar_ausencias.log`
2. Verifica que todas las tablas se importaron correctamente
3. Ejecuta una consulta simple en phpMyAdmin para verificar la conexión:
   ```sql
   SELECT COUNT(*) FROM usuarios;
   ```
4. Revisa la configuración en `config/db.php`

---

**Generado automáticamente por exportar_db.php**
**Fecha: 2025-12-28**
**Sistema: SICA - Sistema Integrado de Convivencia y Asistencia**
