<?php
require_once 'config/db.php';
require_once 'config/functions.php';

requerirAutenticacion();

// Asegurar que solo haya un año activo (corrección automática)
$activos = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' ORDER BY id")->fetchAll();
if (count($activos) > 1) {
    foreach ($activos as $index => $activo) {
        if ($index > 0) {
            query("UPDATE anios_lectivos SET estado = 'inactivo' WHERE id = ?", [$activo['id']]);
        }
    }
}

// Obtener información del usuario actual
$usuario_id = $_SESSION['usuario_id'];
$usuario_rol = $_SESSION['usuario_rol'];

// Obtener año lectivo seleccionado (de sesión)
$anio_activo = getInfoAnioLectivoSeleccionado();

// Estadísticas según rol
$estadisticas = [];

if ($usuario_rol === 'admin') {
    // Estadísticas generales para administrador
    $estadisticas['total_estudiantes'] = query("SELECT COUNT(*) FROM estudiantes WHERE estado = 'activo'")->fetchColumn();
    $estadisticas['total_usuarios'] = query("SELECT COUNT(*) FROM usuarios WHERE estado = 'activo'")->fetchColumn();

    // Estadísticas de hoy
    $hoy = date('Y-m-d');
    $estadisticas['asistencias_hoy'] = query("SELECT COUNT(*) FROM asistencias WHERE fecha = ?", [$hoy])->fetchColumn();

    // Tardanzas: buscar estado 'Tardanza' en estados_asistencia
    $estadisticas['tardanzas_hoy'] = query("
        SELECT COUNT(*) FROM asistencias a
        INNER JOIN estados_asistencia ea ON a.id_estado_asistencia = ea.id
        WHERE a.fecha = ? AND ea.nombre = 'Tardanza'
    ", [$hoy])->fetchColumn();

    // Faltas: buscar estados que contengan 'Falta' en estados_asistencia
    $estadisticas['faltas_hoy'] = query("
        SELECT COUNT(*) FROM asistencias a
        INNER JOIN estados_asistencia ea ON a.id_estado_asistencia = ea.id
        WHERE a.fecha = ? AND (ea.nombre LIKE '%Falta%' OR ea.nombre LIKE '%falta%')
    ", [$hoy])->fetchColumn();
    $estadisticas['incidencias_mes'] = query("SELECT COUNT(*) FROM incidencias WHERE YEAR(fecha) = YEAR(CURDATE()) AND MONTH(fecha) = MONTH(CURDATE())")->fetchColumn();

} elseif ($usuario_rol === 'docente') {
    // Estadísticas del docente (simplified)
    $estadisticas['incidencias_mes'] = 0; // Placeholder

} elseif ($usuario_rol === 'auxiliar') {
    // Estadísticas del auxiliar
    $hoy = date('Y-m-d');
    $estadisticas['asistencias_hoy'] = query("SELECT COUNT(*) FROM asistencias WHERE fecha = ?", [$hoy])->fetchColumn();
    $estadisticas['tardanzas_hoy'] = query("
        SELECT COUNT(*) FROM asistencias a
        INNER JOIN estados_asistencia ea ON a.id_estado_asistencia = ea.id
        WHERE a.fecha = ? AND ea.nombre = 'Tardanza'
    ", [$hoy])->fetchColumn();

} elseif ($usuario_rol === 'estudiante') {
    // Información del estudiante
    $estudiante = query("SELECT e.* FROM estudiantes e WHERE e.id_usuario = ?", [$usuario_id])->fetch();

    if ($estudiante) {
        // Estadísticas del estudiante - usando JOIN con estados_asistencia
        $estadisticas['mis_asistencias'] = query("
            SELECT COUNT(*) FROM asistencias a
            INNER JOIN estados_asistencia ea ON a.id_estado_asistencia = ea.id
            WHERE a.id_estudiante = ? AND ea.nombre = 'Asistencia'
        ", [$estudiante['id']])->fetchColumn();

        $estadisticas['mis_tardanzas'] = query("
            SELECT COUNT(*) FROM asistencias a
            INNER JOIN estados_asistencia ea ON a.id_estado_asistencia = ea.id
            WHERE a.id_estudiante = ? AND ea.nombre LIKE '%Tardanza%'
        ", [$estudiante['id']])->fetchColumn();

        $estadisticas['mis_faltas'] = query("
            SELECT COUNT(*) FROM asistencias a
            INNER JOIN estados_asistencia ea ON a.id_estado_asistencia = ea.id
            WHERE a.id_estudiante = ? AND (ea.nombre LIKE '%Falta%' OR ea.nombre LIKE '%falta%')
        ", [$estudiante['id']])->fetchColumn();

        $estadisticas['mis_incidencias'] = query("SELECT COUNT(*) FROM incidencias WHERE id_estudiante = ?", [$estudiante['id']])->fetchColumn();
    }

} elseif ($usuario_rol === 'apoderado') {
    // Placeholder para apoderados
    $estadisticas['total_estudiantes'] = 0;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <title>SICA - Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        /* Dashboard-specific styles */
        html, body {
            width: 100%;
            overflow-x: hidden;
        }

        .top-bar {
            background: white;
            padding: 15px 30px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            transition: transform 0.3s, box-shadow 0.3s;
            height: 100%;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .stat-card .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
            margin-bottom: 15px;
        }
        .stat-card.primary .stat-icon { background: rgba(59, 130, 246, 0.15); color: var(--secondary-color); }
        .stat-card.success .stat-icon { background: rgba(16, 185, 129, 0.15); color: var(--success-color); }
        .stat-card.warning .stat-icon { background: rgba(245, 158, 11, 0.15); color: var(--warning-color); }
        .stat-card.danger .stat-icon { background: rgba(239, 68, 68, 0.15); color: var(--danger-color); }
        .stat-card .stat-value {
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 5px;
        }
        .stat-card .stat-label {
            color: #6b7280;
            font-size: 0.9rem;
        }
        .anio-badge {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 8px 20px;
            border-radius: 25px;
            font-weight: 600;
        }

        /* Estilos críticos para móvil */
        @media (max-width: 768px) {
            * {
                box-sizing: border-box;
            }

            body {
                width: 100% !important;
                overflow-x: hidden !important;
            }

            .main-content {
                width: 100% !important;
                max-width: 100% !important;
                margin-left: 0 !important;
                padding: 15px 10px !important;
            }

            .top-bar {
                padding: 10px 15px !important;
                flex-direction: column;
                align-items: flex-start !important;
                gap: 10px;
                width: 100% !important;
            }

            .top-bar .d-flex {
                width: 100%;
            }

            .stat-card {
                padding: 15px !important;
            }

            .stat-card .stat-icon {
                width: 45px;
                height: 45px;
                font-size: 1.4rem;
            }

            .stat-card .stat-value {
                font-size: 1.8rem !important;
            }

            .row {
                margin: 0 !important;
            }

            .row > * {
                padding: 0 5px !important;
            }
        }

        @media (max-width: 576px) {
            .main-content {
                padding: 10px 5px !important;
            }

            .row {
                margin: 0 !important;
            }

            .row > * {
                padding: 0 3px !important;
            }
        }
    </style>
</head>
<body>
    <?php include 'includes/layout_elems.php'; ?>

    <!-- Top Bar -->
        <div class="top-bar">
            <div class="d-flex align-items-center">
                <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                    <i class="bi bi-list fs-4"></i>
                </button>
                <h4 class="mb-0">Dashboard</h4>
            </div>
            <div class="d-flex align-items-center gap-3">
                <span class="anio-badge">
                    <i class="bi bi-calendar4-range me-2"></i><?= $anio_activo['anio'] ?>
                </span>
                <div class="dropdown">
                    <button class="btn btn-light rounded-circle" data-bs-toggle="dropdown">
                        <i class="bi bi-bell-fill"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><h6 class="dropdown-header">Notificaciones</h6></li>
                        <li><a class="dropdown-item" href="#">No hay notificaciones nuevas</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Alertas -->
        <?php if ($alerta = getAlerta()): ?>
            <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show" role="alert">
                <?= $alerta['mensaje'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Estadísticas -->
        <?php if ($usuario_rol === 'admin'): ?>
            <div class="row g-4 mb-4">
                <div class="col-12">
                    <h5 class="mb-3">Estadísticas Generales</h5>
                </div>
                <div class="col-md-4 col-sm-6">
                    <div class="stat-card primary">
                        <div class="stat-icon"><i class="bi bi-backpack-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['total_estudiantes'] ?? 0 ?></div>
                        <div class="stat-label">Estudiantes Activos</div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-6">
                    <div class="stat-card success">
                        <div class="stat-icon"><i class="bi bi-people-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['total_usuarios'] ?? 0 ?></div>
                        <div class="stat-label">Usuarios Activos</div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-6">
                    <div class="stat-card warning">
                        <div class="stat-icon"><i class="bi bi-exclamation-triangle-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['incidencias_mes'] ?? 0 ?></div>
                        <div class="stat-label">Incidencias este mes</div>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-12">
                    <h5 class="mb-3">Actividad de Hoy - <?= date('d/m/Y') ?></h5>
                </div>
                <div class="col-md-4 col-sm-6">
                    <div class="stat-card success">
                        <div class="stat-icon"><i class="bi bi-check-circle-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['asistencias_hoy'] ?? 0 ?></div>
                        <div class="stat-label">Asistencias registradas</div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-6">
                    <div class="stat-card warning">
                        <div class="stat-icon"><i class="bi bi-clock-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['tardanzas_hoy'] ?? 0 ?></div>
                        <div class="stat-label">Tardanzas</div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-6">
                    <div class="stat-card danger">
                        <div class="stat-icon"><i class="bi bi-x-circle-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['faltas_hoy'] ?? 0 ?></div>
                        <div class="stat-label">Faltas</div>
                    </div>
                </div>
            </div>

        <?php elseif ($usuario_rol === 'estudiante'): ?>
            <div class="row g-4">
                <div class="col-12">
                    <h5 class="mb-3">Mi Rendimiento - <?= $anio_activo['anio'] ?? '' ?></h5>
                </div>
                <div class="col-md-3 col-sm-6">
                    <div class="stat-card success">
                        <div class="stat-icon"><i class="bi bi-check-circle-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['mis_asistencias'] ?? 0 ?></div>
                        <div class="stat-label">Asistencias</div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6">
                    <div class="stat-card warning">
                        <div class="stat-icon"><i class="bi bi-clock-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['mis_tardanzas'] ?? 0 ?></div>
                        <div class="stat-label">Tardanzas</div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6">
                    <div class="stat-card danger">
                        <div class="stat-icon"><i class="bi bi-x-circle-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['mis_faltas'] ?? 0 ?></div>
                        <div class="stat-label">Faltas</div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6">
                    <div class="stat-card primary">
                        <div class="stat-icon"><i class="bi bi-exclamation-triangle-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['mis_incidencias'] ?? 0 ?></div>
                        <div class="stat-label">Incidencias</div>
                    </div>
                </div>
            </div>

        <?php elseif ($usuario_rol === 'docente'): ?>
            <div class="row g-4">
                <div class="col-12">
                    <h5 class="mb-3">Bienvenido Docente - <?= $anio_activo['anio'] ?? '' ?></h5>
                </div>
                <div class="col-12">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle-fill me-2"></i>
                        Módulo de docentes en desarrollo. Próximamente podrá registrar incidencias y ver reportes.
                    </div>
                </div>
            </div>

        <?php elseif ($usuario_rol === 'auxiliar'): ?>
            <div class="row g-4">
                <div class="col-12">
                    <h5 class="mb-3">Actividad de Hoy</h5>
                </div>
                <div class="col-md-6 col-sm-6">
                    <div class="stat-card success">
                        <div class="stat-icon"><i class="bi bi-check-circle-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['asistencias_hoy'] ?? 0 ?></div>
                        <div class="stat-label">Asistencias registradas</div>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6">
                    <div class="stat-card warning">
                        <div class="stat-icon"><i class="bi bi-clock-fill"></i></div>
                        <div class="stat-value"><?= $estadisticas['tardanzas_hoy'] ?? 0 ?></div>
                        <div class="stat-label">Tardanzas hoy</div>
                    </div>
                </div>
            </div>

        <?php elseif ($usuario_rol === 'apoderado'): ?>
            <div class="alert alert-info">
                <i class="bi bi-info-circle-fill me-2"></i>
                Bienvenido al portal de apoderados. Use el menú lateral para ver la información de sus hijos.
            </div>
        <?php endif; ?>

    <?php include 'includes/layout_scripts.php'; ?>
</body>
</html>
