<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirRol(['admin']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';

    if ($accion === 'crear') {
        $usuario = sanitizar($_POST['usuario'] ?? '');
        $password = $_POST['password'] ?? '';
        $rol = $_POST['rol'] ?? '';

        if (empty($usuario) || empty($password) || empty($rol)) {
            setAlerta('danger', 'Complete todos los campos');
        } else {
            $existe = query("SELECT id FROM usuarios WHERE usuario = ?", [$usuario])->fetch();
            if ($existe) {
                setAlerta('danger', 'El usuario ya existe');
            } else {
                $hash = password_hash($password, PASSWORD_DEFAULT);
                query("INSERT INTO usuarios (usuario, password, rol) VALUES (?, ?, ?)", [$usuario, $hash, $rol]);
                setAlerta('success', 'Usuario creado');
            }
        }
    } elseif ($accion === 'editar') {
        $id = $_POST['id'] ?? '';
        $usuario = sanitizar($_POST['usuario'] ?? '');
        $rol = $_POST['rol'] ?? '';
        $password = $_POST['password'] ?? '';
        $estado = $_POST['estado'] ?? 'activo';

        if (empty($usuario) || empty($rol)) {
            setAlerta('danger', 'Complete todos los campos obligatorios');
        } else {
            $existe = query("SELECT id FROM usuarios WHERE usuario = ? AND id != ?", [$usuario, $id])->fetch();
            if ($existe) {
                setAlerta('danger', 'El usuario ya existe');
            } else {
                if (!empty($password)) {
                    $hash = password_hash($password, PASSWORD_DEFAULT);
                    query("UPDATE usuarios SET usuario = ?, rol = ?, estado = ?, password = ? WHERE id = ?", [$usuario, $rol, $estado, $hash, $id]);
                } else {
                    query("UPDATE usuarios SET usuario = ?, rol = ?, estado = ? WHERE id = ?", [$usuario, $rol, $estado, $id]);
                }
                setAlerta('success', 'Usuario actualizado');
            }
        }
    } elseif ($accion === 'toggle_estado') {
        $id = $_POST['id'] ?? '';
        $user = query("SELECT estado FROM usuarios WHERE id = ?", [$id])->fetch();
        $nuevo_estado = $user['estado'] === 'activo' ? 'inactivo' : 'activo';
        query("UPDATE usuarios SET estado = ? WHERE id = ?", [$nuevo_estado, $id]);
        setAlerta('success', 'Estado actualizado');
    } elseif ($accion === 'eliminar') {
        $id = $_POST['id'] ?? '';
        if ($id == $_SESSION['usuario_id']) {
            setAlerta('danger', 'No puedes eliminar tu propio usuario');
        } else {
            query("DELETE FROM usuarios WHERE id = ?", [$id]);
            setAlerta('success', 'Usuario eliminado');
        }
    }
    header('Location: usuarios.php');
    exit;
}

// Verificar si estamos editando
$modo_edicion = false;
$usuario_editar = null;
if (isset($_GET['editar'])) {
    $id_editar = (int)$_GET['editar'];
    $usuario_editar = query("SELECT * FROM usuarios WHERE id = ?", [$id_editar])->fetch();
    if ($usuario_editar) {
        $modo_edicion = true;
    }
}

$usuarios = query("SELECT * FROM usuarios ORDER BY usuario")->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Usuarios del Sistema</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .content-card { background: white; border-radius: 15px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); padding: 25px; }
    </style>
</head>
<body>
    <nav class="sidebar"><?php include '../includes/sidebar.php'; ?></nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div><h3 class="mb-1">Usuarios del Sistema</h3><p class="text-muted mb-0">Gestión de accesos y permisos</p></div>
            <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Volver</a>
        </div>

        <?php if ($alerta = getAlerta()): ?>
            <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show"><?= $alerta['mensaje'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-4">
                <div class="content-card">
                    <h5 class="mb-3"><?= $modo_edicion ? 'Editar Usuario' : 'Nuevo Usuario' ?></h5>
                    <form method="POST">
                        <input type="hidden" name="accion" value="<?= $modo_edicion ? 'editar' : 'crear' ?>">
                        <?php if ($modo_edicion): ?>
                            <input type="hidden" name="id" value="<?= $usuario_editar['id'] ?>">
                        <?php endif; ?>
                        <div class="mb-3"><label class="form-label">Usuario</label><input type="text" name="usuario" class="form-control" value="<?= $modo_edicion ? htmlspecialchars($usuario_editar['usuario']) : '' ?>" required></div>
                        <div class="mb-3">
                            <label class="form-label"><?= $modo_edicion ? 'Nueva Contraseña (dejar vacío para mantener)' : 'Contraseña' ?></label>
                            <input type="password" name="password" class="form-control" <?= !$modo_edicion ? 'required' : '' ?>>
                        </div>
                        <div class="mb-3"><label class="form-label">Rol</label><select name="rol" class="form-select" required>
                            <option value="">Seleccione</option>
                            <option value="admin" <?= $modo_edicion && $usuario_editar['rol'] === 'admin' ? 'selected' : '' ?>>Administrador</option>
                            <option value="docente" <?= $modo_edicion && $usuario_editar['rol'] === 'docente' ? 'selected' : '' ?>>Docente</option>
                            <option value="auxiliar" <?= $modo_edicion && $usuario_editar['rol'] === 'auxiliar' ? 'selected' : '' ?>>Auxiliar</option>
                            <option value="estudiante" <?= $modo_edicion && $usuario_editar['rol'] === 'estudiante' ? 'selected' : '' ?>>Estudiante</option>
                            <option value="apoderado" <?= $modo_edicion && $usuario_editar['rol'] === 'apoderado' ? 'selected' : '' ?>>Apoderado</option>
                        </select></div>
                        <?php if ($modo_edicion): ?>
                            <div class="mb-3"><label class="form-label">Estado</label><select name="estado" class="form-select">
                                <option value="activo" <?= $usuario_editar['estado'] === 'activo' ? 'selected' : '' ?>>Activo</option>
                                <option value="inactivo" <?= $usuario_editar['estado'] === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
                            </select></div>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary flex-fill"><i class="bi bi-save me-2"></i>Guardar</button>
                                <a href="usuarios.php" class="btn btn-secondary">Cancelar</a>
                            </div>
                        <?php else: ?>
                            <button type="submit" class="btn btn-primary w-100"><i class="bi bi-plus-circle me-2"></i>Crear</button>
                        <?php endif; ?>
                    </form>
                </div>
            </div>

            <div class="col-md-8">
                <div class="content-card">
                    <h5 class="mb-3">Usuarios Registrados</h5>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead><tr><th>Usuario</th><th>Rol</th><th>Estado</th><th>Acciones</th></tr></thead>
                            <tbody>
                                <?php foreach ($usuarios as $u): ?>
                                <tr>
                                    <td><strong><?= htmlspecialchars($u['usuario']) ?></strong></td>
                                    <td><span class="badge bg-info"><?= nombreRol($u['rol']) ?></span></td>
                                    <td><span class="badge bg-<?= $u['estado'] === 'activo' ? 'success' : 'secondary' ?>"><?= $u['estado'] ?></span></td>
                                    <td>
                                        <a href="usuarios.php?editar=<?= $u['id'] ?>" class="btn btn-sm btn-primary" title="Editar"><i class="bi bi-pencil"></i></a>
                                        <form method="POST" class="d-inline" onsubmit="return confirm('¿<?= $u['estado'] === 'activo' ? 'Desactivar' : 'Activar' ?>?')">
                                            <input type="hidden" name="accion" value="toggle_estado">
                                            <input type="hidden" name="id" value="<?= $u['id'] ?>">
                                            <button class="btn btn-sm btn-<?= $u['estado'] === 'activo' ? 'warning' : 'success' ?>"><i class="bi bi-<?= $u['estado'] === 'activo' ? 'pause' : 'play' ?>-fill"></i></button>
                                        </form>
                                        <?php if ($u['id'] != $_SESSION['usuario_id']): ?>
                                            <form method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar usuario?')">
                                                <input type="hidden" name="accion" value="eliminar">
                                                <input type="hidden" name="id" value="<?= $u['id'] ?>">
                                                <button class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
