<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirRol(['admin']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';

    if ($accion === 'crear') {
        $tipo = sanitizar($_POST['tipo'] ?? '');
        $descripcion = sanitizar($_POST['descripcion'] ?? '');
        $gravedad = $_POST['gravedad'] ?? 'media';
        $puntos_penalidad = (int)($_POST['puntos_penalidad'] ?? 0);

        query("INSERT INTO tipos_incidencia (tipo, descripcion, gravedad, puntos_penalidad) VALUES (?, ?, ?, ?)",
            [$tipo, $descripcion, $gravedad, $puntos_penalidad]);
        setAlerta('success', 'Tipo de incidencia creado');
    } elseif ($accion === 'editar') {
        $id = $_POST['id'] ?? '';
        $tipo = sanitizar($_POST['tipo'] ?? '');
        $descripcion = sanitizar($_POST['descripcion'] ?? '');
        $gravedad = $_POST['gravedad'] ?? 'media';
        $puntos_penalidad = (int)($_POST['puntos_penalidad'] ?? 0);

        query("UPDATE tipos_incidencia SET tipo = ?, descripcion = ?, gravedad = ?, puntos_penalidad = ? WHERE id = ?",
            [$tipo, $descripcion, $gravedad, $puntos_penalidad, $id]);
        setAlerta('success', 'Tipo de incidencia actualizado');
    } elseif ($accion === 'eliminar') {
        $id = $_POST['id'] ?? '';
        $tiene = query("SELECT COUNT(*) FROM incidencias WHERE id_tipo_incidencia = ?", [$id])->fetchColumn();
        if ($tiene > 0) setAlerta('danger', 'No se puede eliminar: tiene incidencias registradas');
        else { query("DELETE FROM tipos_incidencia WHERE id = ?", [$id]); setAlerta('success', 'Eliminado'); }
    }
    header('Location: tipos_incidencia.php');
    exit;
}

// Verificar si estamos editando
$modo_edicion = false;
$tipo_editar = null;
if (isset($_GET['editar'])) {
    $id_editar = (int)$_GET['editar'];
    $tipo_editar = query("SELECT * FROM tipos_incidencia WHERE id = ?", [$id_editar])->fetch();
    if ($tipo_editar) {
        $modo_edicion = true;
    }
}

$tipos = query("SELECT * FROM tipos_incidencia ORDER BY FIELD(gravedad, 'baja','media','alta','muy_alta'), tipo")->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Tipos de Incidencia</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .content-card { background: white; border-radius: 15px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); padding: 25px; }
    </style>
</head>
<body>
    <nav class="sidebar"><?php include '../includes/sidebar.php'; ?></nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div><h3 class="mb-1">Tipos de Incidencia</h3><p class="text-muted mb-0">Catálogo de faltas e inconductas</p></div>
            <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Volver</a>
        </div>

        <?php if ($alerta = getAlerta()): ?>
            <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show"><?= $alerta['mensaje'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-4">
                <div class="content-card">
                    <h5 class="mb-3"><?= $modo_edicion ? 'Editar Tipo' : 'Nuevo Tipo' ?></h5>
                    <form method="POST">
                        <input type="hidden" name="accion" value="<?= $modo_edicion ? 'editar' : 'crear' ?>">
                        <?php if ($modo_edicion): ?>
                            <input type="hidden" name="id" value="<?= $tipo_editar['id'] ?>">
                        <?php endif; ?>
                        <div class="mb-3"><label class="form-label">Tipo</label><input type="text" name="tipo" class="form-control" value="<?= $modo_edicion ? htmlspecialchars($tipo_editar['tipo']) : '' ?>" required></div>
                        <div class="mb-3"><label class="form-label">Descripción</label><textarea name="descripcion" class="form-control" rows="2"><?= $modo_edicion ? htmlspecialchars($tipo_editar['descripcion']) : '' ?></textarea></div>
                        <div class="mb-3"><label class="form-label">Gravedad</label><select name="gravedad" class="form-select">
                            <option value="baja" <?= $modo_edicion && $tipo_editar['gravedad'] === 'baja' ? 'selected' : '' ?>>Baja</option>
                            <option value="media" <?= $modo_edicion && $tipo_editar['gravedad'] === 'media' ? 'selected' : '' ?>>Media</option>
                            <option value="alta" <?= $modo_edicion && $tipo_editar['gravedad'] === 'alta' ? 'selected' : '' ?>>Alta</option>
                            <option value="muy_alta" <?= $modo_edicion && $tipo_editar['gravedad'] === 'muy_alta' ? 'selected' : '' ?>>Muy Alta</option>
                        </select></div>
                        <div class="mb-3"><label class="form-label">Puntos de Penalidad</label><input type="number" name="puntos_penalidad" class="form-control" value="<?= $modo_edicion ? (int)$tipo_editar['puntos_penalidad'] : 0 ?>" min="0" max="100"></div>
                        <?php if ($modo_edicion): ?>
                            <div class="d-flex gap-2 mt-3">
                                <button type="submit" class="btn btn-primary flex-fill"><i class="bi bi-save me-2"></i>Guardar</button>
                                <a href="tipos_incidencia.php" class="btn btn-secondary">Cancelar</a>
                            </div>
                        <?php else: ?>
                            <button type="submit" class="btn btn-primary w-100 mt-3"><i class="bi bi-plus-circle me-2"></i>Crear</button>
                        <?php endif; ?>
                    </form>
                </div>
            </div>

            <div class="col-md-8">
                <div class="content-card">
                    <h5 class="mb-3">Tipos Registrados</h5>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead><tr><th>Tipo</th><th>Descripción</th><th>Gravedad</th><th>Puntos</th><th>Acciones</th></tr></thead>
                            <tbody>
                                <?php foreach ($tipos as $t): ?>
                                <tr>
                                    <td><strong><?= htmlspecialchars($t['tipo']) ?></strong></td>
                                    <td><small class="text-muted"><?= htmlspecialchars($t['descripcion']) ?></small></td>
                                    <td>
                                        <?php
                                        $badge_class = match($t['gravedad']) {
                                            'baja' => 'bg-success',
                                            'media' => 'bg-warning',
                                            'alta' => 'bg-danger',
                                            'muy_alta' => 'bg-dark',
                                            default => 'bg-secondary'
                                        };
                                        ?>
                                        <span class="badge <?= $badge_class ?> text-white"><?= ucfirst($t['gravedad']) ?></span>
                                    </td>
                                    <td><span class="badge bg-info text-white"><?= (int)$t['puntos_penalidad'] ?> pts</span></td>
                                    <td>
                                        <a href="tipos_incidencia.php?editar=<?= $t['id'] ?>" class="btn btn-sm btn-primary" title="Editar"><i class="bi bi-pencil"></i></a>
                                        <form method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar?')">
                                            <input type="hidden" name="accion" value="eliminar">
                                            <input type="hidden" name="id" value="<?= $t['id'] ?>">
                                            <button class="btn btn-sm btn-danger" title="Eliminar"><i class="bi bi-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
