<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirRol(['admin']);

$errores = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';
    $id = $_POST['id'] ?? '';
    $id_grado = $_POST['id_grado'] ?? '';
    $id_turno = $_POST['id_turno'] ?? '';
    $seccion = sanitizar($_POST['seccion'] ?? '');
    $capacidad = $_POST['capacidad'] ?? 30;

    if ($accion === 'crear') {
        if (empty($id_grado) || empty($seccion) || empty($id_turno)) {
            $errores[] = 'Complete todos los campos obligatorios';
        } else {
            $anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();
            $grado_info = query("SELECT * FROM grados WHERE id = ?", [$id_grado])->fetch();

            $existe = query("SELECT id FROM secciones WHERE id_grado = ? AND id_turno = ? AND seccion = ? AND id_anio_lectivo = ?",
                [$id_grado, $id_turno, $seccion, $anio_activo['id']])->fetch();
            if ($existe) {
                $errores[] = 'La sección ya existe para este grado y turno';
            } else {
                query("INSERT INTO secciones (id_nivel, id_grado, id_turno, id_anio_lectivo, grado, seccion, capacidad) VALUES (?, ?, ?, ?, ?, ?, ?)",
                    [$grado_info['id_nivel'], $id_grado, $id_turno, $anio_activo['id'], $grado_info['grado'], $seccion, $capacidad]);
                setAlerta('success', 'Sección creada');
            }
        }
    } elseif ($accion === 'editar') {
        if (empty($id_grado) || empty($seccion) || empty($id_turno)) {
            $errores[] = 'Complete todos los campos obligatorios';
        } else {
            $anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();
            $grado_info = query("SELECT * FROM grados WHERE id = ?", [$id_grado])->fetch();

            $existe = query("SELECT id FROM secciones WHERE id_grado = ? AND id_turno = ? AND seccion = ? AND id_anio_lectivo = ? AND id != ?",
                [$id_grado, $id_turno, $seccion, $anio_activo['id'], (int)$id])->fetch();
            if ($existe) {
                $errores[] = 'La sección ya existe para este grado y turno';
            } else {
                query("UPDATE secciones SET id_nivel = ?, id_grado = ?, id_turno = ?, grado = ?, seccion = ?, capacidad = ? WHERE id = ?",
                    [$grado_info['id_nivel'], $id_grado, $id_turno, $grado_info['grado'], $seccion, $capacidad, $id]);
                setAlerta('success', 'Sección actualizada');
            }
        }
    } elseif ($accion === 'eliminar') {
        // Verificar si tiene programaciones asociadas
        $tiene_prog = query("SELECT COUNT(*) FROM programaciones WHERE id_seccion = ?", [$id])->fetchColumn();
        if ($tiene_prog > 0) {
            $errores[] = 'No se puede eliminar: tiene programaciones asociadas';
        } else {
            query("DELETE FROM secciones WHERE id = ?", [$id]);
            setAlerta('success', 'Sección eliminada');
        }
    }

    if (empty($errores)) {
        header('Location: secciones.php');
        exit;
    }
}

// Verificar si estamos editando
$modo_edicion = false;
$seccion_editar = null;
if (isset($_GET['editar'])) {
    $id_editar = (int)$_GET['editar'];
    $seccion_editar = query("SELECT * FROM secciones WHERE id = ?", [$id_editar])->fetch();
    if ($seccion_editar) {
        $modo_edicion = true;
    }
}

$niveles = query("SELECT * FROM niveles WHERE estado = 'activo'")->fetchAll();
$turnos = query("SELECT * FROM turnos WHERE estado = 'activo' ORDER BY nombre")->fetchAll();
$anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();

// Obtener filtros
$filtro_nivel = $_GET['filtro_nivel'] ?? '';
$filtro_grado = $_GET['filtro_grado'] ?? '';
$filtro_turno = $_GET['filtro_turno'] ?? '';

// Construir consulta con filtros
$sql = "SELECT s.*, g.grado, n.nombre AS nivel, t.nombre as turno, t.abreviatura as turno_abrev
        FROM secciones s
        LEFT JOIN grados g ON s.id_grado = g.id
        LEFT JOIN niveles n ON s.id_nivel = n.id
        LEFT JOIN turnos t ON t.id = s.id_turno
        WHERE s.id_anio_lectivo = ?";
$params = [$anio_activo['id']];

if ($filtro_nivel) {
    $sql .= " AND s.id_nivel = ?";
    $params[] = $filtro_nivel;
}

if ($filtro_grado) {
    $sql .= " AND s.id_grado = ?";
    $params[] = $filtro_grado;
}

if ($filtro_turno) {
    $sql .= " AND s.id_turno = ?";
    $params[] = $filtro_turno;
}

$sql .= " ORDER BY n.nombre, g.grado, s.seccion";

$secciones = query($sql, $params)->fetchAll();

// Obtener grados para filtros
$grados_filtro = [];
if ($filtro_nivel) {
    $grados_filtro = query("SELECT * FROM grados WHERE id_nivel = ? AND id_anio_lectivo = ? ORDER BY grado",
        [$filtro_nivel, $anio_activo['id']])->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Secciones</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .content-card { background: white; border-radius: 15px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); padding: 25px; }
        .badge-mañana { background: #f59b23; }
        .badge-tarde { background: #3b82f6; }
    </style>
</head>
<body>
    <nav class="sidebar"><?php include '../includes/sidebar.php'; ?></nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div><h3 class="mb-1">Secciones</h3><p class="text-muted mb-0">Gestión de secciones por grado</p></div>
            <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Volver</a>
        </div>

        <?php if ($alerta = getAlerta()): ?>
            <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show"><?= $alerta['mensaje'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>

        <?php if (!empty($errores)): ?>
            <div class="alert alert-danger"><?php foreach ($errores as $e) echo "$e<br>"; ?></div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-4">
                <div class="content-card">
                    <h5 class="mb-3"><?= $modo_edicion ? 'Editar Sección' : 'Nueva Sección' ?></h5>
                    <form method="POST">
                        <input type="hidden" name="accion" value="<?= $modo_edicion ? 'editar' : 'crear' ?>">
                        <?php if ($modo_edicion): ?>
                            <input type="hidden" name="id" value="<?= $seccion_editar['id'] ?>">
                        <?php endif; ?>
                        <div class="mb-3">
                            <label class="form-label">Nivel <span class="text-danger">*</span></label>
                            <select name="id_nivel" class="form-select" required onchange="cargarGrados(this.value)">
                                <option value="">Seleccione</option>
                                <?php foreach ($niveles as $n): ?>
                                    <option value="<?= $n['id'] ?>" <?= $modo_edicion && $seccion_editar['id_nivel'] == $n['id'] ? 'selected' : '' ?>><?= $n['nombre'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Grado <span class="text-danger">*</span></label>
                            <select name="id_grado" id="id_grado" class="form-select" required>
                                <option value="">Seleccione nivel primero</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Turno <span class="text-danger">*</span></label>
                            <select name="id_turno" class="form-select" required>
                                <option value="">Seleccione</option>
                                <?php foreach ($turnos as $t): ?>
                                    <option value="<?= $t['id'] ?>" <?= $modo_edicion && $seccion_editar['id_turno'] == $t['id'] ? 'selected' : '' ?>>
                                        <?= $t['nombre'] ?> (<?= $t['abreviatura'] ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sección <span class="text-danger">*</span></label>
                            <input type="text" name="seccion" class="form-control" placeholder="A, B, C..."
                                   value="<?= $modo_edicion ? htmlspecialchars($seccion_editar['seccion']) : '' ?>" required maxlength="2" style="text-transform:uppercase;">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Capacidad</label>
                            <input type="number" name="capacidad" class="form-control" value="<?= $modo_edicion ? $seccion_editar['capacidad'] : 30 ?>" min="1" max="100">
                        </div>
                        <?php if ($modo_edicion): ?>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary flex-fill"><i class="bi bi-save me-2"></i>Guardar</button>
                                <a href="secciones.php" class="btn btn-secondary">Cancelar</a>
                            </div>
                        <?php else: ?>
                            <button type="submit" class="btn btn-primary w-100"><i class="bi bi-plus-circle me-2"></i>Crear</button>
                        <?php endif; ?>
                    </form>
                </div>
            </div>

            <div class="col-md-8">
                <div class="content-card">
                    <h5 class="mb-3">Secciones Registradas</h5>

                    <!-- Filtros -->
                    <form method="GET" class="mb-4">
                        <div class="row g-2">
                            <div class="col-md-3">
                                <select name="filtro_nivel" class="form-select form-select-sm" onchange="this.form.submit()">
                                    <option value="">Todos los niveles</option>
                                    <?php foreach ($niveles as $n): ?>
                                        <option value="<?= $n['id'] ?>" <?= $filtro_nivel == $n['id'] ? 'selected' : '' ?>>
                                            <?= $n['nombre'] ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="filtro_grado" class="form-select form-select-sm" <?= $filtro_nivel ? '' : 'disabled' ?> onchange="this.form.submit()">
                                    <option value="">Todos los grados</option>
                                    <?php foreach ($grados_filtro as $g): ?>
                                        <option value="<?= $g['id'] ?>" <?= $filtro_grado == $g['id'] ? 'selected' : '' ?>>
                                            <?= $g['grado'] ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="filtro_turno" class="form-select form-select-sm" onchange="this.form.submit()">
                                    <option value="">Todos los turnos</option>
                                    <?php foreach ($turnos as $t): ?>
                                        <option value="<?= $t['id'] ?>" <?= $filtro_turno == $t['id'] ? 'selected' : '' ?>>
                                            <?= $t['nombre'] ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <?php if ($filtro_nivel || $filtro_grado || $filtro_turno): ?>
                                    <a href="secciones.php" class="btn btn-sm btn-outline-secondary w-100">
                                        <i class="bi bi-x-lg me-1"></i>Limpiar
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead><tr><th>Nivel</th><th>Grado</th><th>Turno</th><th>Sección</th><th>Capacidad</th><th>Acciones</th></tr></thead>
                            <tbody>
                                <?php foreach ($secciones as $s): ?>
                                <tr>
                                    <td><?= $s['nivel'] ?></td>
                                    <td><?= $s['grado'] ?></td>
                                    <td>
                                        <span class="badge badge-<?= strtolower($s['turno']) ?>">
                                            <?= $s['turno'] ?>
                                        </span>
                                    </td>
                                    <td><span class="badge bg-primary"><?= $s['seccion'] ?></span></td>
                                    <td><?= $s['capacidad'] ?></td>
                                    <td>
                                        <a href="secciones.php?editar=<?= $s['id'] ?>" class="btn btn-sm btn-primary" title="Editar"><i class="bi bi-pencil"></i></a>
                                        <form method="POST" class="d-inline" onsubmit="return confirm('¿Eliminar sección?')">
                                            <input type="hidden" name="accion" value="eliminar">
                                            <input type="hidden" name="id" value="<?= $s['id'] ?>">
                                            <button class="btn btn-sm btn-danger" title="Eliminar"><i class="bi bi-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script>
        let gradosCache = {};

        function cargarGrados(idNivel, gradoSeleccionado = '') {
            if (!idNivel) {
                $('#id_grado').html('<option value="">Seleccione nivel primero</option>');
                return;
            }

            if (gradosCache[idNivel]) {
                mostrarGrados(gradosCache[idNivel], gradoSeleccionado);
                return;
            }

            $.get('/SICA/config/ajax.php', {action: 'get_grados_by_id', id_nivel: idNivel}, function(data) {
                gradosCache[idNivel] = data;
                mostrarGrados(data, gradoSeleccionado);
            }, 'json');
        }

        function mostrarGrados(data, seleccionado) {
            let html = '<option value="">Seleccione</option>';
            data.forEach(g => {
                let selected = g.id == seleccionado ? 'selected' : '';
                html += '<option value="' + g.id + '" ' + selected + '>' + g.grado + '</option>';
            });
            $('#id_grado').html(html);
        }

        $(document).ready(function() {
            <?php if ($modo_edicion && $seccion_editar): ?>
                cargarGrados(<?= $seccion_editar['id_nivel'] ?>, <?= $seccion_editar['id_grado'] ?? 0 ?>);
            <?php endif; ?>
        });
    </script>
</body>
</html>
