<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Configuración</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .config-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            padding: 25px;
            transition: transform 0.3s, box-shadow 0.3s;
            cursor: pointer;
            height: 100%;
        }
        .config-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .config-card .icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
            margin-bottom: 15px;
        }
        .config-card.blue .icon { background: rgba(59, 130, 246, 0.15); color: #3b82f6; }
        .config-card.green .icon { background: rgba(16, 185, 129, 0.15); color: #10b981; }
        .config-card.purple .icon { background: rgba(139, 92, 246, 0.15); color: #8b5cf6; }
        .config-card.orange .icon { background: rgba(245, 158, 11, 0.15); color: #f59e0b; }
        .config-card.red .icon { background: rgba(239, 68, 68, 0.15); color: #ef4444; }
        .config-card.cyan .icon { background: rgba(6, 182, 212, 0.15); color: #06b6d4; }
        .config-card.pink .icon { background: rgba(236, 72, 153, 0.15); color: #ec4899; }
        .config-card.gray .icon { background: rgba(107, 114, 128, 0.15); color: #6b7280; }
    </style>
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
            <div class="d-flex align-items-center">
                <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                    <i class="bi bi-list fs-4"></i>
                </button>
                <div>
                    <h3 class="mb-1">Configuración del Sistema</h3>
                    <p class="text-muted mb-0">Administre los parámetros y opciones del sistema SICA</p>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-md-6 col-lg-4">
                <a href="anios_lectivos.php" class="text-decoration-none">
                    <div class="config-card blue">
                        <div class="icon"><i class="bi bi-calendar-range"></i></div>
                        <h5>Años Lectivos</h5>
                        <p class="text-muted small">Gestione los años escolares y sus periodos académicos</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="niveles.php" class="text-decoration-none">
                    <div class="config-card green">
                        <div class="icon"><i class="bi bi-layers-fill"></i></div>
                        <h5>Niveles Educativos</h5>
                        <p class="text-muted small">Configure Inicial, Primaria y Secundaria</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="grados.php" class="text-decoration-none">
                    <div class="config-card purple">
                        <div class="icon"><i class="bi bi-sort-numeric-up"></i></div>
                        <h5>Grados</h5>
                        <p class="text-muted small">Administre los grados de cada nivel educativo</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="secciones.php" class="text-decoration-none">
                    <div class="config-card orange">
                        <div class="icon"><i class="bi bi-grid-3x3-gap"></i></div>
                        <h5>Secciones</h5>
                        <p class="text-muted small">Gestione las secciones (A, B, C, etc.) de cada grado</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="turnos.php" class="text-decoration-none">
                    <div class="config-card" style="background: linear-gradient(135deg, #f59e0b15 0%, #fbbf2415 100%);">
                        <div class="icon" style="background: rgba(245, 158, 11, 0.15); color: #f59e0b;"><i class="bi bi-sun-fill"></i></div>
                        <h5>Turnos</h5>
                        <p class="text-muted small">Administre los turnos (Mañana, Tarde, Noche) con sus horarios</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="areas_academicas.php" class="text-decoration-none">
                    <div class="config-card orange">
                        <div class="icon"><i class="bi bi-bookmarks"></i></div>
                        <h5>Áreas Académicas</h5>
                        <p class="text-muted small">Gestione las áreas académicas por nivel educativo</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="horarios.php" class="text-decoration-none">
                    <div class="config-card cyan">
                        <div class="icon"><i class="bi bi-clock-fill"></i></div>
                        <h5>Horarios</h5>
                        <p class="text-muted small">Asigne turnos a cada nivel educativo</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="tipos_incidencia.php" class="text-decoration-none">
                    <div class="config-card red">
                        <div class="icon"><i class="bi bi-exclamation-triangle-fill"></i></div>
                        <h5>Tipos de Incidencia</h5>
                        <p class="text-muted small">Defina las faltas y su nivel de gravedad</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="estados_asistencia.php" class="text-decoration-none">
                    <div class="config-card cyan">
                        <div class="icon"><i class="bi bi-clipboard-check"></i></div>
                        <h5>Estados de Asistencia</h5>
                        <p class="text-muted small">Configure estados (Asistencia, Tardanza, Falta, etc.)</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="calendario.php" class="text-decoration-none">
                    <div class="config-card red">
                        <div class="icon"><i class="bi bi-calendar-event"></i></div>
                        <h5>Calendario</h5>
                        <p class="text-muted small">Registre feriados, vacaciones y días no laborables</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="usuarios.php" class="text-decoration-none">
                    <div class="config-card pink">
                        <div class="icon"><i class="bi bi-people-fill"></i></div>
                        <h5>Usuarios del Sistema</h5>
                        <p class="text-muted small">Administre accesos y permisos de usuarios</p>
                    </div>
                </a>
            </div>

            <div class="col-md-6 col-lg-4">
                <a href="parametros.php" class="text-decoration-none">
                    <div class="config-card gray">
                        <div class="icon"><i class="bi bi-sliders"></i></div>
                        <h5>Parámetros del Sistema</h5>
                        <p class="text-muted small">Configure límites, alertas y opciones generales</p>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <?php include '../includes/layout_scripts.php'; ?>
</body>
</html>
