<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirRol(['admin']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';

    if ($accion === 'guardar') {
        $id_nivel = $_POST['id_nivel'] ?? '';
        $id_turno = $_POST['id_turno'] ?? '';

        $anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();

        // Verificar si ya existe
        $existe = query("SELECT id FROM horarios WHERE id_nivel = ? AND id_anio_lectivo = ? AND id_turno = ?",
            [$id_nivel, $anio_activo['id'], $id_turno])->fetch();

        if ($existe) {
            setAlerta('danger', 'Ya existe un horario para este nivel y turno');
        } else {
            query("INSERT INTO horarios (id_nivel, id_anio_lectivo, id_turno, estado) VALUES (?, ?, ?, 'activo')",
                [$id_nivel, $anio_activo['id'], $id_turno]);
            setAlerta('success', 'Horario creado');
        }
        header('Location: horarios.php');
        exit;
    } elseif ($accion === 'eliminar') {
        $id = $_POST['id'] ?? '';
        query("DELETE FROM horarios WHERE id = ?", [$id]);
        setAlerta('success', 'Horario eliminado');
        header('Location: horarios.php');
        exit;
    }
}

$niveles = query("SELECT * FROM niveles WHERE estado = 'activo'")->fetchAll();
$turnos = query("SELECT * FROM turnos WHERE estado = 'activo' ORDER BY nombre")->fetchAll();
$anio_activo = query("SELECT id FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();

// Obtener horarios existentes agrupados por nivel
$horarios = [];
foreach ($niveles as $n) {
    $h = query("
        SELECT h.*, t.nombre as turno_nombre, t.abreviatura, t.hora_ingreso, t.hora_salida, t.tolerancia_minutos
        FROM horarios h
        INNER JOIN turnos t ON t.id = h.id_turno
        WHERE h.id_nivel = ? AND h.id_anio_lectivo = ?
    ", [$n['id'], $anio_activo['id']])->fetchAll();
    $horarios[$n['id']] = $h;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Horarios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
    <style>
        .horario-card {
            border-left: 4px solid #3b82f6;
            background: #f8fafc;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 15px;
            transition: all 0.3s;
        }
        .horario-card:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .horario-card.turno-mañana { border-left-color: #f59b23; }
        .horario-card.turno-tarde { border-left-color: #3b82f6; }
        .badge-mañana { background: #f59b23; }
        .badge-tarde { background: #3b82f6; }
    </style>
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="d-flex align-items-center">
            <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                <i class="bi bi-list fs-4"></i>
            </button>
            <div>
                <h3 class="mb-0">Horarios por Nivel</h3>
                <p class="text-muted mb-0">Asigne turnos a cada nivel educativo</p>
            </div>
        </div>
        <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Volver</a>
    </div>

    <?php if ($alerta = getAlerta()): ?>
        <div class="alert alert-<?= $alerta['tipo'] ?> alert-dismissible fade show"><?= $alerta['mensaje'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h6 class="mb-0"><i class="bi bi-plus-circle me-2"></i>Asignar Horario</h6>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <input type="hidden" name="accion" value="guardar">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Nivel <span class="text-danger">*</span></label>
                            <select name="id_nivel" class="form-select" required>
                                <option value="">Seleccionar...</option>
                                <?php foreach ($niveles as $n): ?>
                                    <option value="<?= $n['id'] ?>"><?= $n['nombre'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Turno <span class="text-danger">*</span></label>
                            <select name="id_turno" class="form-select" required>
                                <option value="">Seleccionar...</option>
                                <?php foreach ($turnos as $t): ?>
                                    <option value="<?= $t['id'] ?>">
                                        <?= $t['nombre'] ?> (<?= $t['abreviatura'] ?>)
                                        - <?= substr($t['hora_ingreso'], 0, 5) ?> a <?= substr($t['hora_salida'], 0, 5) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <small class="form-text text-muted">
                                Los horarios se toman de la configuración de Turnos
                            </small>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="bi bi-check-circle me-2"></i>Asignar Horario
                        </button>
                    </form>
                </div>
            </div>

            <div class="card border-0 shadow-sm">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="bi bi-info-circle me-2"></i>Instrucciones</h6>
                </div>
                <div class="card-body">
                    <ul class="mb-0 small">
                        <li>Seleccione el nivel educativo</li>
                        <li>Seleccione el turno (Mañana/Tarde)</li>
                        <li>Los horarios se asignan automáticamente desde la configuración de Turnos</li>
                        <li>Un nivel puede tener múltiples turnos</li>
                        <li><strong>Para modificar horarios:</strong> Vaya a la configuración de Turnos</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h6 class="mb-0"><i class="bi bi-clock me-2"></i>Horarios Asignados</h6>
                </div>
                <div class="card-body">
                    <?php
                    $tiene_horarios = false;
                    foreach ($horarios as $h) {
                        if (!empty($h)) {
                            $tiene_horarios = true;
                            break;
                        }
                    }

                    if (!$tiene_horarios): ?>
                        <div class="text-center py-5">
                            <i class="bi bi-clock fs-1 text-muted"></i>
                            <p class="text-muted mt-3">No hay horarios asignados</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($niveles as $n): ?>
                            <?php if (!empty($horarios[$n['id']])): ?>
                                <div class="mb-4">
                                    <h6 class="text-primary fw-bold mb-3">
                                        <i class="bi bi-grid-3x3-gap me-2"></i><?= $n['nombre'] ?>
                                    </h6>
                                    <?php foreach ($horarios[$n['id']] as $h): ?>
                                        <div class="horario-card turno-<?= strtolower($h['turno_nombre']) ?>">
                                            <div class="d-flex justify-content-between align-items-start">
                                                <div>
                                                    <h6 class="mb-1">
                                                        <span class="badge badge-<?= strtolower($h['turno_nombre']) ?>">
                                                            <?= $h['turno_nombre'] ?>
                                                        </span>
                                                    </h6>
                                                    <div class="text-muted small">
                                                        <i class="bi bi-clock me-1"></i>
                                                        <?= substr($h['hora_ingreso'], 0, 5) ?> - <?= substr($h['hora_salida'], 0, 5) ?>
                                                        <span class="ms-3">
                                                            <i class="bi bi-exclamation-triangle me-1"></i>
                                                            Tolerancia: <?= $h['tolerancia_minutos'] ?> min
                                                        </span>
                                                    </div>
                                                </div>
                                                <form method="POST" class="ms-2" onsubmit="return confirm('¿Eliminar horario?')">
                                                    <input type="hidden" name="accion" value="eliminar">
                                                    <input type="hidden" name="id" value="<?= $h['id'] ?>">
                                                    <button class="btn btn-sm btn-outline-danger" title="Eliminar">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php include '../includes/layout_scripts.php'; ?>
</body>
</html>
