<?php
require_once '../config/db.php';
require_once '../config/functions.php';
requerirAutenticacion();

if ($_SESSION['usuario_rol'] !== 'admin') {
    header('Location: /SICA/dashboard.php');
    exit;
}

$id = $_GET['id'] ?? 0;

if (!$id) {
    header('Location: turnos.php');
    exit;
}

// Verificar si el turno existe
$stmt = $pdo->prepare("SELECT * FROM turnos WHERE id = ?");
$stmt->execute([$id]);
$turno = $stmt->fetch();

if (!$turno) {
    header('Location: turnos.php');
    exit;
}

$errores = [];
$exito = false;

// Verificar si está siendo usado en secciones
$stmt = $pdo->prepare("
    SELECT COUNT(*) as total
    FROM secciones
    WHERE id_turno = ?
");
$stmt->execute([$id]);
$total_secciones = $stmt->fetch()['total'];

// Verificar si está siendo usado en programaciones
$stmt = $pdo->prepare("
    SELECT COUNT(*) as total
    FROM programaciones
    WHERE id_turno = ?
");
$stmt->execute([$id]);
$total_programaciones = $stmt->fetch()['total'];

// Procesar eliminación
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';

    try {
        $pdo->beginTransaction();

        if ($accion === 'eliminar') {
            // Eliminar completamente (las FK se encargarán de las relaciones)
            $stmt = $pdo->prepare("DELETE FROM turnos WHERE id = ?");
            $stmt->execute([$id]);

            $pdo->commit();
            $exito = 'eliminado';

        } elseif ($accion === 'inactivar') {
            // Cambiar a inactivo
            $stmt = $pdo->prepare("
                UPDATE turnos
                SET estado = 'inactivo', updated_at = NOW()
                WHERE id = ?
            ");
            $stmt->execute([$id]);

            $pdo->commit();
            $exito = 'inactivado';
        }

        header("Location: turnos.php?exito=$exito");
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        $errores[] = $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Eliminar Turno - SICA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <?php include '../includes/layout_elems.php'; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
            <div class="d-flex align-items-center">
                <button class="btn btn-link d-lg-none me-3" onclick="toggleSidebarMobile()">
                    <i class="bi bi-list fs-4"></i>
                </button>
                <div>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-1">
                            <li class="breadcrumb-item"><a href="index.php" class="text-decoration-none">Configuración</a></li>
                            <li class="breadcrumb-item"><a href="turnos.php" class="text-decoration-none">Turnos</a></li>
                            <li class="breadcrumb-item active">Eliminar</li>
                        </ol>
                    </nav>
                    <h3 class="mb-0">Eliminar Turno</h3>
                </div>
            </div>
            <a href="turnos.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Volver
            </a>
        </div>

        <?php include '../includes/layout_scripts.php'; ?>'; ?>
</body>
</html>
