<?php
/**
 * DIAGNÓSTICO DE CALENDARIO
 * Verifica qué feriados existen en la base de datos y por qué se muestran
 */

require_once 'db.php';

echo "=== DIAGNÓSTICO DE CALENDARIO ===\n\n";

// 1. Ver año del sistema
$anio_sistema = date('Y');
echo "1. AÑO DEL SISTEMA: {$anio_sistema}\n\n";

// 2. Ver año lectivo activo
$anio_lectivo_activo = query("SELECT id, anio, estado FROM anios_lectivos WHERE estado = 'activo' LIMIT 1")->fetch();
if ($anio_lectivo_activo) {
    echo "2. AÑO LECTIVO ACTIVO:\n";
    echo "   ID: {$anio_lectivo_activo['id']}\n";
    echo "   Nombre: {$anio_lectivo_activo['anio']}\n";
    echo "   Estado: {$anio_lectivo_activo['estado']}\n\n";
} else {
    echo "2. AÑO LECTIVO ACTIVO: No encontrado\n\n";
}

// 3. Contar feriados por año
echo "3. FERIADOS GLOBALES POR AÑO:\n";
$feriados_por_anio = query("
    SELECT
        YEAR(fecha) as anio,
        COUNT(*) as total,
        GROUP_CONCAT(nombre ORDER BY fecha SEPARATOR ', ') as nombres
    FROM calendario
    WHERE aniolectivo_id IS NULL
      AND estado = 'activo'
    GROUP BY YEAR(fecha)
    ORDER BY anio
")->fetchAll();

if (empty($feriados_por_anio)) {
    echo "   ⚠️ NO HAY FERIADOS GLOBALES REGISTRADOS\n\n";
} else {
    foreach ($feriados_por_anio as $row) {
        echo "   Año {$row['anio']}: {$row['total']} feriados\n";
        echo "   Ejemplo: {$row['nombres']}\n\n";
    }
}

// 4. Feriados específicos por año lectivo
echo "4. FERIADOS ESPECÍFICOS POR AÑO LECTIVO:\n";
$feriados_especificos = query("
    SELECT
        an.id as anio_lectivo_id,
        an.anio as anio_lectivo_nombre,
        COUNT(c.id) as total
    FROM anios_lectivos an
    LEFT JOIN calendario c ON c.aniolectivo_id = an.id AND c.estado = 'activo'
    GROUP BY an.id, an.anio
    ORDER BY an.anio
")->fetchAll();

foreach ($feriados_especificos as $row) {
    echo "   Año lectivo {$row['anio_lectivo_nombre']} (ID {$row['anio_lectivo_id']}): {$row['total']} feriados específicos\n";
}
echo "\n";

// 5. ¿Qué mostraría la consulta actual?
if ($anio_lectivo_activo) {
    echo "5. QUÉ MOSTRARÍA LA CONSULTA CON AÑO LECTIVO ID {$anio_lectivo_activo['id']}:\n";
    $resultados = query("
        SELECT
            fecha,
            tipo,
            nombre,
            aniolectivo_id,
            CASE
                WHEN aniolectivo_id IS NULL THEN 'GLOBAL'
                ELSE CONCAT('Específico (ID ', aniolectivo_id, ')')
            END as tipo_registro
        FROM calendario
        WHERE estado = 'activo'
          AND (
              aniolectivo_id = ?
              OR (aniolectivo_id IS NULL AND YEAR(fecha) = ?)
          )
        ORDER BY fecha ASC
        LIMIT 20
    ", [$anio_lectivo_activo['id'], $anio_sistema])->fetchAll();

    if (empty($resultados)) {
        echo "   ⚠️ NO SE ENCONTRARON REGISTROS\n\n";
        echo "   POSIBLE CAUSA: No existen feriados globales del año {$anio_sistema}\n";
        echo "   SOLUCIÓN: Ejecutar el generador de feriados:\n";
        echo "   php generar_calendario_anual.php {$anio_sistema} " . ($anio_sistema + 5) . "\n\n";
    } else {
        echo "   Se encontraron " . count($resultados) . " registros:\n\n";
        foreach ($resultados as $row) {
            echo "   - {$row['fecha']} | {$row['tipo']} | {$row['nombre']} | {$row['tipo_registro']}\n";
        }
        echo "\n";
    }
}

// 6. Mostrar todos los feriados globales (sin filtro)
echo "6. TODOS LOS FERIADOS GLOBALES EN BD (primeros 20):\n";
$todos_globales = query("
    SELECT fecha, tipo, nombre, YEAR(fecha) as anio
    FROM calendario
    WHERE aniolectivo_id IS NULL
      AND estado = 'activo'
    ORDER BY fecha ASC
    LIMIT 20
")->fetchAll();

foreach ($todos_globales as $row) {
    echo "   {$row['fecha']} ({$row['anio']}) | {$row['tipo']} | {$row['nombre']}\n";
}
echo "\n";

// 7. Recomendaciones
echo "=== RECOMENDACIONES ===\n\n";

if (empty($feriados_por_anio)) {
    echo "❌ No hay feriados globales registrados.\n";
    echo "✅ Ejecuta: php generar_calendario_anual.php {$anio_sistema} " . ($anio_sistema + 5) . "\n\n";
} else {
    $existe_anio_sistema = false;
    foreach ($feriados_por_anio as $row) {
        if ($row['anio'] == $anio_sistema) {
            $existe_anio_sistema = true;
            break;
        }
    }

    if (!$existe_anio_sistema) {
        echo "⚠️ Existen feriados globales PERO NO del año {$anio_sistema}.\n";
        echo "✅ Ejecuta: php generar_calendario_anual.php {$anio_sistema} " . ($anio_sistema + 5) . "\n\n";
    } else {
        echo "✅ Existen feriados globales del año {$anio_sistema}.\n";
        echo "✅ El filtrado debería funcionar correctamente.\n\n";
    }
}

echo "=== FIN DEL DIAGNÓSTICO ===\n";
?>
