<?php
/**
 * CRON JOB INTERNO - Verificador de Ausencias
 *
 * Este archivo debe ejecutarse cada 10 minutos para verificar ausencias
 * y registrar automáticamente faltas injustificadas.
 *
 * Se puede llamar desde:
 * 1. Task Scheduler de Windows: curl http://localhost/SICA/config/cron_verificar_ausencias.php
 * 2. Cron job de Linux: */10 * * * * curl http://localhost/SICA/config/cron_verificar_ausencias.php
 * 3. Servicio de cron externo (cron-job.org, easycron.com, etc.)
 */

require_once 'db.php';
require_once 'functions.php';

// Seguridad básica: verificar IP del servidor si es necesario
// $ips_permitidas = ['127.0.0.1', '::1'];
// if (!in_array($_SERVER['REMOTE_ADDR'], $ips_permitidas)) {
//     http_response_code(403);
//     exit('Acceso denegado');
// }

// Ejecutar el script de verificación
require_once __DIR__ . '/../tareas/verificar_ausencias.php';
