<?php
/**
 * Cambiar el año lectivo seleccionado en sesión
 * Y ACTUALIZA el estado en la base de datos para unificar concepto
 */

require_once '../config/db.php';
require_once '../config/functions.php';

requerirAutenticacion();

header('Content-Type: application/json');

$respuesta = [
    'success' => false,
    'mensaje' => ''
];

try {
    global $pdo;

    $anio_id = intval($_POST['anio_id'] ?? 0);

    if (!$anio_id) {
        throw new Exception('ID de año lectivo no válido');
    }

    // Verificar que el año existe
    $anio = query("SELECT id, anio FROM anios_lectivos WHERE id = ?", [$anio_id])->fetch();

    if (!$anio) {
        throw new Exception('El año lectivo no existe');
    }

    // Iniciar transacción
    $pdo->beginTransaction();

    // 1. Poner todos los años como 'inactivo'
    query("UPDATE anios_lectivos SET estado = 'inactivo'");

    // 2. Activar el año seleccionado
    query("UPDATE anios_lectivos SET estado = 'activo' WHERE id = ?", [$anio_id]);

    // 3. Actualizar sesión
    $_SESSION['anio_lectivo_id'] = $anio_id;
    $_SESSION['anio_lectivo_nombre'] = $anio['anio'];

    $pdo->commit();

    $respuesta['success'] = true;
    $respuesta['mensaje'] = 'Año lectivo cambiado correctamente';
    $respuesta['anio_id'] = $anio_id;
    $respuesta['anio_nombre'] = $anio['anio'];

} catch (Exception $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $respuesta['mensaje'] = $e->getMessage();
}

echo json_encode($respuesta);
