<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

$id = intval($_GET['id'] ?? 0);

if (!$id) {
    header('Location: index.php');
    exit;
}

// Obtener apoderado
$apoderado = query("SELECT a.*, u.usuario, u.ultimo_acceso, u.fecha_registro as fecha_registro_usuario
                 FROM apoderados a
                 LEFT JOIN usuarios u ON a.id_usuario = u.id
                 WHERE a.id = :id", ['id' => $id])->fetch();

if (!$apoderado) {
    header('Location: index.php');
    exit;
}

// Obtener año lectivo seleccionado
$anio_seleccionado = getAnioLectivoSeleccionado();

// Obtener estudiantes vinculados en este año lectivo
$estudiantes_vinculados = query("SELECT ea.*, e.dni, e.apellido_paterno, e.apellido_materno, e.nombres
                                FROM estudiantes_apoderados ea
                                INNER JOIN estudiantes e ON ea.id_estudiante = e.id
                                WHERE ea.id_apoderado = :apod AND ea.id_anio_lectivo = :anio
                                ORDER BY e.apellido_paterno, e.apellido_materno",
                                ['apod' => $id, 'anio' => $anio_seleccionado])->fetchAll();

// Obtener info del año lectivo
$info_anio = query("SELECT anio FROM anios_lectivos WHERE id = :id", ['id' => $anio_seleccionado])->fetch();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SICA - Ver Apoderado</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="../assets/css/sica.css?v=5.1" rel="stylesheet">
</head>
<body>
    <nav class="sidebar">
        <?php include '../includes/sidebar.php'; ?>
    </nav>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="mb-1">Detalle del Apoderado</h3>
                <p class="text-muted mb-0">Información completa del apoderado</p>
            </div>
            <a href="index.php" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Volver
            </a>
        </div>

        <div class="row">
            <!-- Información Personal -->
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-person-badge"></i> Información Personal</h5>
                    </div>
                    <div class="card-body">
                        <div class="text-center mb-4">
                            <div class="avatar-circle avatar-lg mb-2">
                                <?= substr($apoderado['nombres'], 0, 1) . substr($apoderado['apellido_paterno'], 0, 1) ?>
                            </div>
                            <h4><?= htmlspecialchars($apoderado['apellido_paterno'] . ' ' . $apoderado['apellido_materno'] . ', ' . $apoderado['nombres']) ?></h4>
                            <p class="text-muted mb-0">@<?= htmlspecialchars($apoderado['usuario']) ?></p>
                        </div>

                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>DNI:</strong></td>
                                <td><?= htmlspecialchars($apoderado['dni']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Apellido Paterno:</strong></td>
                                <td><?= htmlspecialchars($apoderado['apellido_paterno']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Apellido Materno:</strong></td>
                                <td><?= htmlspecialchars($apoderado['apellido_materno']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Nombres:</strong></td>
                                <td><?= htmlspecialchars($apoderado['nombres']) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Género:</strong></td>
                                <td><?= $apoderado['genero'] === 'M' ? 'Masculino' : 'Femenino' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Fecha Nacimiento:</strong></td>
                                <td><?= $apoderado['fecha_nacimiento'] ? date('d/m/Y', strtotime($apoderado['fecha_nacimiento'])) : '-' ?></td>
                            </tr>
                            <tr>
                                <td><strong>Email:</strong></td>
                                <td><?= htmlspecialchars($apoderado['email'] ?: '-') ?></td>
                            </tr>
                            <tr>
                                <td><strong>Teléfono:</strong></td>
                                <td><?= htmlspecialchars($apoderado['telefono'] ?: '-') ?></td>
                            </tr>
                            <tr>
                                <td><strong>Teléfono Alternativo:</strong></td>
                                <td><?= htmlspecialchars($apoderado['telefono_alternativo'] ?: '-') ?></td>
                            </tr>
                            <tr>
                                <td><strong>Dirección:</strong></td>
                                <td><?= htmlspecialchars($apoderado['direccion'] ?: '-') ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Información del Sistema -->
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="bi bi-info-circle"></i> Información del Sistema</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>Usuario:</strong></td>
                                <td>
                                    <code><?= htmlspecialchars($apoderado['usuario']) ?></code>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Rol:</strong></td>
                                <td><span class="badge bg-info">Apoderado</span></td>
                            </tr>
                            <tr>
                                <td><strong>Estado Apoderado:</strong></td>
                                <td>
                                    <?php
                                    $badge_class = match($apoderado['estado']) {
                                        'activo' => 'bg-success',
                                        'inactivo' => 'bg-secondary',
                                        'retirado' => 'bg-warning',
                                        default => 'bg-secondary'
                                    };
                                    ?>
                                    <span class="badge <?= $badge_class ?>">
                                        <?= ucfirst($apoderado['estado']) ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Fecha Registro:</strong></td>
                                <td><?= date('d/m/Y H:i', strtotime($apoderado['fecha_registro_usuario'])) ?></td>
                            </tr>
                            <tr>
                                <td><strong>Último Acceso:</strong></td>
                                <td>
                                    <?php if ($apoderado['ultimo_acceso']): ?>
                                        <?= date('d/m/Y H:i', strtotime($apoderado['ultimo_acceso'])) ?>
                                    <?php else: ?>
                                        <span class="text-muted">Sin accesos</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>

                        <hr>

                        <div class="d-grid gap-2">
                            <a href="editar.php?id=<?= $apoderado['id'] ?>" class="btn btn-primary">
                                <i class="bi bi-pencil"></i> Editar Información
                            </a>
                            <a href="../perfil.php" class="btn btn-outline-primary">
                                <i class="bi bi-key"></i> Cambiar Contraseña
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estudiantes Vinculados -->
        <div class="card mb-4">
            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-people-fill"></i> Estudiantes Vinculados (<?= count($estudiantes_vinculados) ?>) - Año <?= htmlspecialchars($info_anio['anio']) ?></h5>
                <a href="vincular_estudiantes.php?id=<?= $apoderado['id'] ?>" class="btn btn-light btn-sm">
                    <i class="bi bi-plus-circle"></i> Vincular Estudiantes
                </a>
            </div>
            <div class="card-body p-0">
                <?php if (empty($estudiantes_vinculados)): ?>
                    <div class="text-center py-5">
                        <i class="bi bi-person-x text-muted" style="font-size: 3rem;"></i>
                        <p class="text-muted mt-3">No hay estudiantes vinculados en este año lectivo</p>
                        <a href="vincular_estudiantes.php?id=<?= $apoderado['id'] ?>" class="btn btn-info">
                            <i class="bi bi-link-45deg"></i> Vincular Estudiantes
                        </a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>DNI</th>
                                    <th>Estudiante</th>
                                    <th>Parentesco</th>
                                    <th>Estado</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($estudiantes_vinculados as $vinculacion): ?>
                                    <tr>
                                        <td><span class="fw-bold"><?= htmlspecialchars($vinculacion['dni']) ?></span></td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-circle avatar-sm me-2">
                                                    <?= substr($vinculacion['nombres'], 0, 1) . substr($vinculacion['apellido_paterno'], 0, 1) ?>
                                                </div>
                                                <div>
                                                    <div class="fw-bold">
                                                        <?= htmlspecialchars($vinculacion['apellido_paterno'] . ' ' . $vinculacion['apellido_materno'] . ', ' . $vinculacion['nombres']) ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">
                                                <?= htmlspecialchars($vinculacion['parentesco']) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge bg-success">Activo</span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Acciones -->
        <div class="card">
            <div class="card-body">
                <div class="d-flex gap-2">
                    <a href="editar.php?id=<?= $apoderado['id'] ?>" class="btn btn-primary">
                        <i class="bi bi-pencil"></i> Editar
                    </a>
                    <a href="index.php" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Volver al Listado
                    </a>
                    <a href="eliminar.php?id=<?= $apoderado['id'] ?>" class="btn btn-outline-danger ms-auto"
                        onclick="return confirm('¿Está seguro de eliminar este apoderado?')">
                        <i class="bi bi-trash"></i> Eliminar
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
