<?php
require_once '../config/db.php';
require_once '../config/functions.php';

requerirRol(['admin']);

header('Content-Type: application/json');

// Habilitar reporting de errores para debugging
error_reporting(E_ALL);
ini_set('display_errors', 0); // No mostrar en output, solo log

$busqueda = trim($_GET['busqueda'] ?? '');

if (strlen($busqueda) < 3) {
    echo json_encode(['estudiantes' => []]);
    exit;
}

try {
    $anio_lectivo_id = getAnioLectivoSeleccionado();

    if (!$anio_lectivo_id) {
        echo json_encode(['error' => 'No hay año lectivo seleccionado']);
        exit;
    }

    // Buscar estudiantes que:
    // 1. Estén activos
    // 2. NO tengan apoderado asignado en este año lectivo
    // 3. Coincidan con la búsqueda (DNI, apellidos o nombres)
    $sql = "
        SELECT id, dni, apellido_paterno, apellido_materno, nombres
        FROM estudiantes
        WHERE estado = 'activo'
        AND id NOT IN (
            SELECT id_estudiante
            FROM estudiantes_apoderados
            WHERE id_anio_lectivo = ?
        )
        AND (
            dni LIKE ?
            OR apellido_paterno LIKE ?
            OR apellido_materno LIKE ?
            OR nombres LIKE ?
            OR CONCAT(apellido_paterno, ' ', apellido_materno) LIKE ?
            OR CONCAT(apellido_paterno, ' ', apellido_materno, ', ', nombres) LIKE ?
        )
        ORDER BY apellido_paterno, apellido_materno, nombres
        LIMIT 20
    ";

    $parametros = array_fill(0, 7, "%{$busqueda}%");
    $parametros[0] = $anio_lectivo_id; // Primer parámetro es el año lectivo

    $stmt = $pdo->prepare($sql);
    $stmt->execute($parametros);
    $estudiantes = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'estudiantes' => $estudiantes,
        'total' => count($estudiantes),
        'busqueda' => $busqueda,
        'anio_lectivo' => $anio_lectivo_id
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
}
