# ESPECIFICACIONES TÉCNICAS - SICA

## Sistema Integrado de Convivencia y Asistencia

**Fecha:** 23 de Diciembre de 2025
**Versión:** 1.0

---

## 1. DESCRIPCIÓN GENERAL

Sistema web para gestión de aproximadamente 2000 estudiantes de niveles inicial, primaria y secundaria, con control de asistencia, incidencias y notificaciones.

### Tecnología Propuesta:
- **Backend:** PHP 8.x
- **Base de Datos:** MySQL 8.x (SICA2025)
- **Frontend:** HTML5, CSS3, JavaScript Vanilla o jQuery
- **Servidor:** Apache/XAMPP
- **QR:** Biblioteca para generación y lectura de códigos QR

---

## 2. ROLES DEL SISTEMA

| Rol | Descripción | Permisos Principales |
|-----|-------------|---------------------|
| **Administrador** | Gestión completa del sistema | CRUD de todos los datos, configuración, usuarios |
| **Estudiante** | Visualización personal | Ver sus asistencias, tardanzas e inconductas |
| **Docente** | Registro de incidencias | Reportar inconductas, enviar notificaciones |
| **Auxiliar** | Registro de asistencia | Escaneo QR, registro manual de asistencias/tardanzas |
| **Apoderado** | Seguimiento de estudiantes | Recibir notificaciones por email, ver reportes |

---

## 3. MÓDULOS DEL SISTEMA

### 3.1 Autenticación
- Login con credenciales únicas
- Recuperación de contraseña
- Control de sesiones por rol
- Registro de actividad (logs)

### 3.2 Dashboard Principal
- Menú dinámico según rol
- Resumen de estadísticas:
  - Total de estudiantes
  - Asistencias del día
  - Incidencias pendientes
  - Alertas del sistema

### 3.3 Configuración del Sistema

#### Años Lectivos
- Crear años lectivos (2025, 2026, etc.)
- Estado: Activo/Inactivo
- Fechas de inicio y fin

#### Niveles Educativos
- Inicial
- Primaria
- Secundaria
- Configuración de horarios por nivel

#### Horarios
- Hora de entrada por nivel
- Margen de tolerancia para tardanza
- Configuración de días lectivos

#### Secciones
- Creación de secciones (ej: 1° "A", 2° "B")
- Asignación de aulas
- Capacidad por sección

### 3.4 Gestión de Usuarios

#### Apoderados
- Datos personales: DNI, nombres, apellidos, teléfono, email
- Dirección, distrito, referencia
- Estado: Activo/Inactivo

#### Docentes
- Datos personales completos
- Especialidad
- Secciones asignadas
- Usuario de acceso

#### Auxiliares
- Datos personales
- Turno de trabajo
- Usuario de acceso

#### Estudiantes
- **Datos Personales:**
  - DNI (único, código QR)
  - Nombres y apellidos
  - Fecha de nacimiento
  - Género
  - Foto (opcional)

- **Datos Académicos:**
  - Nivel asignado
  - Grado
  - Sección
  - Año lectivo
  - Apoderado vinculado

- **Estado:** Activo, Retirado, Egresado

### 3.5 Registro de Asistencia

#### Modalidades:
1. **Escaneo QR**
   - Lectura de DNI desde código QR
   - Registro automático de fecha/hora
   - Detección de tardanza según horario del nivel

2. **Registro Manual**
   - Búsqueda de estudiante por DNI/nombre
   - Selección de estado: Asistencia, Tardanza, Falta
   - Justificación de tardanza/falta

#### Lógica de Tardanza:
```
SI hora_llegada > hora_entrada_nivel + margen_tolerancia
    ENTONCES registrar como TARDANZA
FIN SI
```

### 3.6 Gestión de Inconductas

#### Registro de Incidencias:
- **Datos:**
  - Estudiante involucrado
  - Docente que reporta
  - Fecha y hora del incidente
  - Tipo de falta (Leve, Grave, Muy Grave)
  - Descripción detallada
  - Medida correctiva aplicada

- **Notificación:**
  - Email automático al apoderado
  - Registro de envío
  - Opción de reenvío

### 3.7 Reportes y Estadísticas

#### Tipos de Reporte:

1. **Individual por Estudiante:**
   - Asistencias por mes/año
   - Tardanzas acumuladas
   - Inconductas registradas
   - Gráfico de comportamiento

2. **Por Sección:**
   - Lista de estudiantes
   - Resumen de asistencias
   - Inconductas por estudiante
   - Exportable a PDF/Excel

3. **Alertas Inteligentes:**
   - Riesgo de perder año (exceso de faltas)
   - Exceso de tardanzas (> umbral configurable)
   - Estudiantes con múltiples inconductas
   - Reporte de apoderados no contactados

### 3.8 Sistema de Notificaciones

#### Configuración de Correo:
- Servidor SMTP
- Puerto, usuario, contraseña
- Remitente del sistema

#### Plantillas de Email:
- Notificación de inconducta
- Alerta de asistencia
- Reporte mensual (opcional)

---

## 4. ESTRUCTURA DE BASE DE DATOS (PRELIMINAR)

```sql
-- Catálogos
anos_lektivos (id, anho, estado, fecha_inicio, fecha_fin)
niveles (id, nombre, estado)
grados (id, nivel_id, nombre, estado)
secciones (id, grado_id, nombre, aula, capacidad)
horarios (id, nivel_id, hora_entrada, tolerancia_minutos)

-- Usuarios
roles (id, nombre, permisos_json)
apoderados (id, dni, nombres, apellidos, telefono, email, direccion, distrito, referencia, estado)
docentes (id, dni, nombres, apellidos, email, especialidad, usuario_id, estado)
auxiliares (id, dni, nombres, apellidos, turno, usuario_id, estado)
estudiantes (id, dni, nombres, apellidos, fecha_nacimiento, genero, foto, nivel_id, grado_id, seccion_id, apoderado_id, anho_lectivo_id, estado)

-- Usuarios y autenticación
usuarios (id, usuario, password_hash, rol_id, estado, ultimo_acceso)
bitacora_sesiones (id, usuario_id, fecha_hora, ip_address, accion)

-- Asistencias
asistencias (id, estudiante_id, fecha, hora_registro, estado, justificacion, observaciones, metodo_registro)
-- estado: 'ASISTENCIA', 'TARDANZA', 'FALTA'

-- Inconductas
tipos_falta (id, nombre, nivel_gravedad)
inconductas (id, estudiante_id, docente_id, tipo_falta_id, fecha_hora, descripcion, medida_correctiva, estado_notificacion)

-- Notificaciones
notificaciones_enviadas (id, inconducta_id, apoderado_id, email, fecha_envio, estado, intentos)

-- Configuración
configuracion_sistema (id, clave, valor, descripcion)
```

---

## 5. FLUJOS DE USUARIO PRINCIPALES

### 5.1 Flujo de Registro de Asistencia (Auxiliar)

```
1. Login como Auxiliar
2. Acceder a módulo "Asistencias"
3. Seleccionar fecha (por defecto hoy)
4. Opción A: Escanear código QR del estudiante
   - Sistema valida DNI
   - Registra hora actual
   - Determina si es ASISTENCIA o TARDANZA según horario del nivel
5. Opción B: Registro manual
   - Buscar estudiante por DNI o nombre
   - Seleccionar estado
   - Agregar observación opcional
6. Confirmar registro
7. Retornar a paso 4 para siguiente estudiante
```

### 5.2 Flujo de Reporte de Inconducta (Docente)

```
1. Login como Docente
2. Acceder a módulo "Inconductas"
3. Click en "Nueva Incidencia"
4. Buscar estudiante involucrado
5. Seleccionar tipo de falta
6. Describir el incidente detalladamente
7. Indicar medida correctiva
8. Confirmar registro
9. Sistema envía email automáticamente al apoderado
10. Mostrar confirmación con código de referencia
```

### 5.3 Flujo de Consulta (Estudiante)

```
1. Login como Estudiante
2. Dashboard muestra:
   - Resumen de asistencias del mes
   - Últimas inconductas (si las hay)
3. Click en "Mis Asistencias"
   - Ver calendario con historial
   - Filtrar por fecha/rango
4. Click en "Mis Inconductas"
   - Ver listado completo
   - Ver detalles de cada incidencia
```

---

## 6. REGLAS DE NEGOCIO

### 6.1 Asistencias
- Un estudiante solo puede tener un registro por día
- La tardanza se determina automáticamente según horario del nivel
- Las faltas pueden justificarse posteriormente por el apoderado o administración

### 6.2 Inconductas
- Toda falta registrada debe notificarse al apoderado
- El docente puede editar su propio reporte dentro de las primeras 24 horas
- El administrador puede editar o eliminar cualquier registro

### 6.3 Usuarios
- El DNI es único para cada persona (apoderados, docentes, auxiliares, estudiantes)
- Un estudiante no puede tener más de un apoderado registrado
- Un docente puede estar asignado a múltiples secciones

### 6.4 Años Lectivos
- Solo un año lectivo puede estar activo a la vez
- Al cambiar de año lectivo, los datos históricos se conservan
- El código QR del estudiante mantiene su DNI independientemente del año

---

## 7. INTERFACES DE USUARIO (REFERENCIA)

*Nota: Las capturas del sistema antiguo proporcionan las siguientes interfaces:*

### 7.1 Pantallas Identificadas
- [ ] Login principal
- [ ] Dashboard administrativo
- [ ] Gestión de apoderados
- [ ] Gestión de docentes
- [ ] Gestión de estudiantes
- [ ] Registro de asistencia (QR y manual)
- [ ] Registro de inconductas
- [ ] Reportes por estudiante
- [ ] Reportes por sección
- [ ] Configuración de años lectivos
- [ ] Configuración de horarios
- [ ] Alertas y notificaciones

*El análisis detallado de cada captura se agregará después de revisar las imágenes.*

---

## 8. REQUERIMIENTOS TÉCNICOS

### 8.1 Servidor
- PHP 7.4 o superior
- MySQL 5.7 o superior
- Apache con mod_rewrite habilitado
- Librería GD para gráficos
- Soporte para correo (SMTP)

### 8.2 Cliente (Navegador)
- Navegadores modernos (Chrome, Firefox, Edge, Safari)
- JavaScript habilitado
- Cookies habilitadas
- Resolución mínima: 1024x768

### 8.3 Seguridad
- Passwords hasheados (bcrypt o Argon2)
- Protección contra SQL Injection (prepared statements)
- Validación de datos en servidor y cliente
- Control de sesiones
- Sanitización de inputs
- CSRF tokens en formularios

---

## 9. CRITERIOS DE ACEPTACIÓN

- [ ] Sistema de login funcional para todos los roles
- [ ] Registro de asistencia con código QR funcional
- [ ] Determinación automática de tardanzas según horarios
- [ ] Registro de inconductas con notificación por email
- [ ] Reporte individual de estudiantes (asistencias + inconductas)
- [ ] Reporte por sección exportable
- [ ] Dashboard con estadísticas básicas
- [ ] Configuración de años lectivos, niveles, grados y secciones
- [ ] Gestión completa de usuarios (CRUD)
- [ ] Alertas inteligentes (riesgo de perder año, exceso de tardanzas)

---

## 10. PRÓXIMOS PASOS

1. ✅ Análisis de especificaciones del archivo leeme.txt
2. ⏳ Análisis detallado de capturas del sistema antiguo
3. ⏳ Diseño final de base de datos con todas las tablas y relaciones
4. ⏳ Diseño de diagramas entidad-relación
5. ⏳ Creación de esquema SQL completo
6. ⏳ Desarrollo de estructura de carpetas y archivos PHP
7. ⏳ Implementación de módulos prioritarios

---

**Documento preparado por:** Claude Code (Asistente de Desarrollo)
**Fecha de creación:** 23 de Diciembre de 2025
